import {html, LitElement} from "../esm/libs/lit.dist.js?ver=2.5.1";
import globalStyles from '../esm/custom-elements/styles.css.js?ver=2.5.1';
import styles from './pk-quick-order-view.css.js?ver=2.5.1';

export class PkQuickCreatedOrderView extends LitElement {

    static styles = [
        globalStyles,
        styles,
    ];

    static properties = {
        createdOrder: {},
    }

    render() {
        return html`
            <div class="text-center">
                <pk-icon icon="parcel-check" style="--pk-icon-size: 10rem;"></pk-icon>
                <div class="d-flex-column mt gap">
                    <div class="fw-bold">
                        Przesyłka została zamówiona
                    </div>
                    <div>
                        Numer zamówienia: 
                        <div>
                            <strong>${this.createdOrder?.order_number}</strong>
                        </div>
                    </div>
                    <div>
                        Numer listu przewozowego: 
                        <div>
                            ${Array.from(this.createdOrder?.label || []).map(label => html`
                                <div>
                                    <strong>${label}</strong>
                                </div>
                            `)}
                        </div>
                    </div>
                </div>
                <p class="d-flex-column gap-sm mt-lg">
                    <a 
                        href="admin.php?page=polkurier_packages&action=label&label=${this.createdOrder?.order_number}&order_id=${this.createdOrder?.order_id}" 
                        class="btn btn-block btn-primary" 
                        target="_blank"
                    >
                        <pk-icon type="plain" icon="print" size="text"></pk-icon>
                        Pobierz etykietę (PDF)
                    </a>
                    <a 
                        href="admin.php?page=polkurier_packages&action=protocol&label=${this.createdOrder?.order_number}&order_id=${this.createdOrder?.order_id}" 
                        class="btn btn-block" 
                        target="_blank"
                    >
                        <pk-icon type="plain" icon="download" size="text"></pk-icon>
                        Pobierz protokół (PDF)
                    </a>
                </p>
            </div>
        `;
    }
}

customElements.define('pk-quick-created-order-view', PkQuickCreatedOrderView);
