import {html, LitElement} from "../esm/libs/lit.dist.js?ver=2.5.1";
import styles from '../esm/custom-elements/styles.css.js?ver=2.5.1';
import '../esm/custom-elements/pk-icon.js?ver=2.5.1';
import '../esm/custom-elements/pk-list.js?ver=2.5.1';

export class PkQuickOrderAddressSelectView extends LitElement {

    static properties = {
        address: {},
        addresses: {},
    };

    static styles = styles;

    render() {
        if (this.addresses?.length <= 0) {
            return html`
                <div class="d-flex gap align-items-center text-danger">
                    <pk-icon icon="parcel-problem" class="text-danger"></pk-icon>
                    <p>
                        Nie masz zdefiniowanych adresów na etykietę.<br>
                        Przejdź do <a href="admin.php?page=polkurier&tab=cover_addresses" target="_blank">ustawień</a>, aby dodać nowy adres.
                    </p>
                </div>
            `;
        }

        return html`
            <pk-list>
                ${this.addresses?.map(address => html`
                    <pk-list-item
                        @click="${() => this.dispatchEvent(new CustomEvent('select', {detail: address}))}"
                        class="cursor-pointer d-flex gap ${address.id === this.address?.id ? 'active' : ''}"
                    >
                        <div>
                            <pk-icon icon="courier-with-parcel"></pk-icon>
                        </div>
                        <div>
                            <div class="fw-bold">${address.company || ''}</div>
                            <div class="fw-bold">${address.person || ''}</div>
                            <div>
                                ${address.street || ''} 
                                ${address.housenumber || ''}
                                ${address.flatnumber ? ` / ${address.flatnumber}` : ''}
                            </div>
                            <div>${address.postcode || ''} ${address.city || ''} (${address.country || 'PL'})</div>
                            <div>${address.phone || ''}, ${address.email || ''}</div>
                        </div>
                    </pk-list-item>
                `)}
            </pk-list>
        `
    }
}

customElements.define("pk-quick-order-address-select-view", PkQuickOrderAddressSelectView);
