import {html, LitElement} from "../esm/libs/lit.dist.js?ver=2.5.1";
import globalStyles from '../esm/custom-elements/styles.css.js?ver=2.5.1';
import styles from './pk-quick-order-view.css.js?ver=2.5.1';
import {TemplatesProvider} from "../esm/providers/templates-provider.js?ver=2.5.1";
import {ProviderController} from "../esm/lit-controllers/provider-controller.js?ver=2.5.1";
import {CouriersProvider} from "../esm/providers/couriers-provider.js?ver=2.5.1";
import '../esm/custom-elements/pk-badge.js?ver=2.5.1';
import '../esm/custom-elements/pk-icon.js?ver=2.5.1';
import '../esm/custom-elements/pk-toggle.js?ver=2.5.1';


export class PkQuickOrderServicesView extends LitElement {

    static styles = [
        globalStyles,
        styles,
    ];

    static properties = {
        order: {},
        shopOrder: {},
        evaluation: {},
        isEvaluated: {type: Boolean},
        isEvaluationRequested: {type: Boolean},
        showResetDefaultCourierButton: {type: Boolean},
    }

    templatesProvider = ProviderController.create(this, new TemplatesProvider());
    couriersProvider = ProviderController.create(this, new CouriersProvider());


    get template() {
        return this.templatesProvider.get(this.order.templateId);
    }

    get courier() {
        return this.couriersProvider.get(this.order.courier);
    }

    setOrder(props) {
        this.order = {
            ...this.order,
            ...props,
        };
        this.dispatchEvent(new CustomEvent('change'));
    }

    hasService(service) {
        return this.order?.courierservice?.[service] === true;
    }

    toggleService(service, toggle) {
        this.setOrder({
            courierservice: {
                ...(this.order?.courierservice || {}),
                [service]: toggle,
            }
        })
    }

    onClickEditCoverAddressButton() {
        this.dispatchEvent(new CustomEvent('clickEditCoverAddressButton'));
    }

    render() {
        const currentTemplate = this.template;
        return html`
            <div class="d-flex gap">
                <div>
                    <pk-icon icon="checklist"></pk-icon>
                </div>
                <div style="flex-grow: 1;">
                    <pk-grid>
                        <pk-col style="--size-lg: 6">
                            <div class="d-flex-column fs-nano">
                                <pk-toggle
                                    class="pk-toggle-small"
                                    .checked="${this.order.insurance > 0}"
                                    .disabled="${this.shopOrder?.total_value <= 0}"
                                    @change="${e => {
                                        this.setOrder({
                                            insurance: e.target.checked 
                                                ? Math.max(0, this.shopOrder?.total_value, this.order?.cod?.codamount)
                                                : 0,
                                        });
                                    }}"
                                >
                                    Ubezpieczenie
                                </pk-toggle>
                                <pk-toggle 
                                    class="pk-toggle-small"
                                    .checked="${this.hasService('ROD')}"
                                    @change="${e => this.toggleService('ROD', e.target.checked)}"
                                >
                                    Dokumenty zwrotne
                                </pk-toggle>
                                <pk-toggle
                                    class="pk-toggle-small"
                                    .checked="${this.hasService('WEEK_COLLECTION')}"
                                    @change="${e => this.toggleService('WEEK_COLLECTION', e.target.checked)}"
                                >
                                    Dostawa weekendowa (InPost)
                                </pk-toggle>
                                <pk-toggle
                                    class="pk-toggle-small"
                                    .checked="${this.hasService('COURIER_WITH_LABEL')}"
                                    @change="${e => this.toggleService('COURIER_WITH_LABEL', e.target.checked)}"
                                >
                                    Podjazd kuriera z wydrukowaną etykietą
                                </pk-toggle>
                                <pk-toggle
                                    class="pk-toggle-small"
                                    .checked="${this.hasService('LABELLESS')}"
                                    @change="${e => this.toggleService('LABELLESS', e.target.checked)}"
                                >
                                    Nadanie bez etykiety
                                </pk-toggle>
                                <pk-toggle
                                    class="pk-toggle-small"
                                    .checked="${this.hasService('HANDLE_WITH_CARE')}"
                                    @change="${e => this.toggleService('HANDLE_WITH_CARE', e.target.checked)}"
                                >
                                    Ostrożnie
                                </pk-toggle>
                                <pk-toggle
                                    class="pk-toggle-small"
                                    .checked="${this.hasService('HAND_DELIVERY')}"
                                    @change="${e => this.toggleService('HAND_DELIVERY', e.target.checked)}"
                                >
                                    Doręczenie do rąk własnych
                                </pk-toggle>
                            </div>
                        </pk-col>
                        <pk-col style="--size-lg: 6">
                            <div class="d-flex-column fs-nano">
                                <pk-toggle
                                    class="pk-toggle-small"
                                    .checked="${this.hasService('CHECK_CONTENT')}"
                                    @change="${e => this.toggleService('CHECK_CONTENT', e.target.checked)}"
                                >
                                    Sprawdzenie zawartości
                                </pk-toggle>
                                <pk-toggle
                                    class="pk-toggle-small"
                                    .checked="${this.hasService('BRINGING_DELIVERED_PARCEL')}"
                                    @change="${e => this.toggleService('BRINGING_DELIVERED_PARCEL', e.target.checked)}"
                                >
                                    Wniesienie przesyłki
                                </pk-toggle>
                                <pk-toggle
                                    class="pk-toggle-small"
                                    .checked="${this.hasService('SATURDAY_DELIVERY')}"
                                    @change="${e => this.toggleService('SATURDAY_DELIVERY', e.target.checked)}"
                                >
                                    Dostawa w sobotę
                                </pk-toggle>
                                <pk-toggle
                                    class="pk-toggle-small"
                                    .checked="${this.hasService('PHONE_NOTIFICATION_RECIPIENT')}"
                                    @change="${e => this.toggleService('PHONE_NOTIFICATION_RECIPIENT', e.target.checked)}"
                                >
                                    Awizacja telefoniczna przed doręczeniem
                                </pk-toggle>
                                <pk-toggle
                                    class="pk-toggle-small"
                                    .checked="${this.hasService('SMS_NOTIFICATION_RECIPIENT')}"
                                    @change="${e => {
                                        this.toggleService('SMS_NOTIFICATION_RECIPIENT', e.target.checked)
                                        this.toggleService('SMS_NOTIFICATION_RECIPIENT_WITH_NAME', false)
                                    }}"
                                >
                                    Powiadomienie SMS dla odbiorcy
                                </pk-toggle>
                                <pk-toggle
                                    class="pk-toggle-small"
                                    .checked="${this.hasService('SMS_NOTIFICATION_RECIPIENT_WITH_NAME')}"
                                    @change="${e => {
                                        this.toggleService('SMS_NOTIFICATION_RECIPIENT', false)
                                        this.toggleService('SMS_NOTIFICATION_RECIPIENT_WITH_NAME', e.target.checked)
                                    }}"
                                >
                                    Powiadomienie SMS dla odbiorcy z własną nazwą
                                </pk-toggle>
                                <pk-toggle
                                    class="pk-toggle-small"
                                    .checked="${this.hasService('COVER_ADDRESS_SENDER')}"
                                    @change="${e => this.toggleService('COVER_ADDRESS_SENDER', e.target.checked)}"
                                >
                                    Inny adres nadawcy na etykiecie

                                    ${this.hasService('COVER_ADDRESS_SENDER') ? html`
                                        <div slot="description">
                                            ${this.order?.cover_address ? html`
                                                <div>
                                                    <div class="fw-bold d-flex gap-sm">
                                                        ${this.order?.cover_address?.company || ''}
                                                        ${this.order?.cover_address?.person || ''}
                                                        <button class="btn btn-raised btn-rounded btn-icon" @click="${this.onClickEditCoverAddressButton}" title="Zmień adres">
                                                            <pk-icon icon="pencil" size="text" type="plain" ></pk-icon>
                                                        </button>
                                                    </div>
                                                    <div>
                                                        ${this.order?.cover_address?.street || ''} 
                                                        ${this.order?.cover_address?.housenumber || ''}
                                                        ${this.order?.cover_address?.flatnumber ? ` / ${this.order?.cover_address?.flatnumber}` : ''},
                                                        ${this.order?.cover_address?.postcode || ''} ${this.order?.cover_address?.city || ''} (${this.order?.country || 'PL'})
                                                    </div>
                                                    <div>${this.order?.cover_address?.phone || ''}, ${this.order?.cover_address?.email || ''}</div>
                                                </div>
                                            ` : html`
                                                <span class="text-danger">Brak adresu</span>
                                                <button class="btn btn-raised btn-rounded btn-icon" @click="${this.onClickEditCoverAddressButton}" title="Zmień adres">
                                                    <pk-icon icon="plus" size="text" type="plain" ></pk-icon>
                                                </button>
                                            `}
                                        </div>
                                    ` : null}
                                </pk-toggle>
                            </div>
                        </pk-col>
                    </pk-grid>
                </div>
            </div>
        `;
    }
}

customElements.define('pk-quick-order-services-view', PkQuickOrderServicesView);
