import {css, html, LitElement} from '../libs/lit.dist.js?ver=2.5.1';
import styles from './styles.css.js?ver=2.5.1';
import './pk-spinner.js?ver=2.5.1';

export class PkCard extends LitElement {
    static styles = [
        styles,
        css`
            :host {
                display: flex;
                flex-direction: column;
                border-radius: var(--pk-border-radius);
                padding: 0.75rem 1.25rem;
                border: 1px solid var(--pk-card-border-color, var(--pk-gray-300));
                box-shadow: var(--pk-box-shadow);
                background-color: var(--pk-card-background, white);
                box-sizing: border-box;
            }
            
            :host([type="info"]) {
                color: var(--pk-blue-700);
                --pk-card-border-color: var(--pk-blue-300); 
                --pk-card-background: var(--pk-blue-100);
                --pk-icon-bg: var(--pk-blue-200);
                --pk-btn-color: var(--pk-blue-700);
                --pk-btn-bg-color: var(--pk-blue-100);
                --pk-btn-border-color: var(--pk-blue-300);
            }       
            
            :host([type="danger"]) {
                color: var(--pk-orange-700);
                --pk-card-border-color: var(--pk-orange-300); 
                --pk-card-background: var(--pk-orange-100);
                --pk-icon-bg: var(--pk-orange-200);
                --pk-icon-color: var(--pk-orange-700);
                --pk-btn-color: var(--pk-orange-700);
                --pk-btn-bg-color: var(--pk-orange-100);
                --pk-btn-border-color: var(--pk-orange-300);
            }

            :host([type="warning"]) {
                color: var(--pk-yellow-900);
                --pk-card-border-color: var(--pk-yellow-400);
                --pk-card-background: var(--pk-yellow-100);
                --pk-icon-bg: var(--pk-yellow-300);
                --pk-icon-color: var(--pk-yellow-900);
                --pk-btn-color: var(--pk-yellow-900);
                --pk-btn-bg-color: var(--pk-yellow-100);
                --pk-btn-border-color: var(--pk-yellow-500);
            }
            
            :host([type="success"]) {
                color: var(--pk-green-600);
                --pk-card-border-color: var(--pk-green-300);
                --pk-card-background: var(--pk-green-100);
                --pk-icon-bg: var(--pk-green-200);
                --pk-icon-color: var(--pk-green-500);
                --pk-btn-color: var(--pk-green-600);
                --pk-btn-bg-color: var(--pk-green-100);
                --pk-btn-border-color: var(--pk-green-500);
            }
        `,
    ];
    render() {
        return html`<slot></slot>`
    }
}

window.customElements.define('pk-card', PkCard);
