import {css, html, LitElement} from '../libs/lit.dist.js?ver=2.5.1';
import styles from './styles.css.js?ver=2.5.1';
import './pk-spinner.js?ver=2.5.1';

export class PkList extends LitElement {
    static styles = [
        styles,
        css`
            :host {
                --__border-radius: var(--pk-border-radius, 0.375rem);
                display: flex;
                flex-direction: column;
                padding-left: 0;
                margin-bottom: 0;
                border-radius: var(--__border-radius);
                box-shadow: var(--pk-box-shadow);
                background-color: var(--background, white);
            }
    
            pk-list-item {
                --pk-border-radius: var(--__border-radius);
            }
        `,
    ];
    render() {
        return html`<slot></slot>`
    }
}

window.customElements.define('pk-list', PkList);

export class PkListItem extends LitElement {
    static styles = css`
        :host {
            display: block;
            padding: 0.5rem 1rem;
            text-decoration: none;
            border: 1px solid var(--pk-gray-300);
        }
        
        :host(:not(:last-child)) {
            border-bottom-width: 0;
        }

        :host(:first-child) {
            border-top-left-radius: var(--pk-border-radius);
            border-top-right-radius: var(--pk-border-radius);
        }

        :host(:last-child) {
            border-bottom-right-radius: var(--pk-border-radius);
            border-bottom-left-radius: var(--pk-border-radius);
        }
        
        :host(.active) {
            background-color: var(--active-bg, var(--pk-blue-600));
            border-color: var(--active-border-bg, var(--active-bg, var(--pk-blue-600)));
            color: var(--active-color, white);
            --pk-icon-color: var(--active-color, white);
            --pk-icon-bg: color(from var(--pk-icon-color) xyz x y z / 0.1);
        }
        
        :host(:hover:not(.active)) {
            background-color: var(--hover-bg, var(--pk-gray-100));
        }
    `;

    render() {
        return html`<slot></slot>`
    }
}

window.customElements.define('pk-list-item', PkListItem);
