import {html, LitElement, css} from "../libs/lit.dist.js?ver=2.5.1";
import styles from './styles.css.js?ver=2.5.1';
import './pk-spinner.js?ver=2.5.1';

export class PkLoadingView extends LitElement {

    static styles = [
        styles,
        css`
            .loader {
                min-height: var(--pk-min-height, 4rem);
                display: flex;
                align-items: center;
                justify-content: center;
            }
        `,
    ];

    static properties = {
        loading: {type: Boolean},
    }

    render() {
        if (this.loading) {
            return html`
                <slot name="loader">
                    <div class="text-center loader">
                        <pk-spinner size="sm"></pk-spinner>
                    </div>
                </slot>
            `;
        }
        return html`<slot></slot>`;
    }
}

customElements.define('pk-loading-view', PkLoadingView);
