import {css} from '../libs/lit.dist.js?ver=2.5.1';

export default css`

    :host {
        --pk-box-shadow: 0 0.2rem 0.1rem rgba(0, 0, 0, 0.05);
        --pk-box-shadow-raised: 0 0.4rem 0.2rem rgba(0, 0, 0, 0.075);
        --pk-border-radius: 0.5rem;
        font-size: 13px;
        
        --pk-input-font-size: 13px;
        --pk-input-border-radius: 0.25rem;
        --pk-input-padding: 0.5rem;
        --pk-input-border-color: var(--pk-gray-400);
        --pk-input-active-color: var(--pk-blue-700);
        --pk-input-background: white;
        --pk-input-color: var(--pk-gray-900);
        --pk-input-disabled-background: var(--pk-gray-200);
    }
    
    * {
        box-sizing: border-box;
    }
    
    .cursor-pointer {
        cursor: pointer;
    }
    
    .text-muted {
        opacity: 0.7;
    }
    
    .text-danger {
        color: var(--pk-red-700);
    }
    
    .text-start {
        text-align: start;
    }
    
    .text-center {
        text-align: center;
    }
    
    .text-end {
        text-align: end;
    }
    
    .text-nowrap {
        white-space: nowrap;
    }

    .fs-sm {
        font-size: 0.8rem;
    }

    .fs-nano {
        font-size: 0.65rem;
    }
    
    .fw-bold {
        font-weight: bold;
    }
    
    .btn {
        --__pk-btn-bg-color: var(--pk-btn-bg-color, var(--pk-gray-200));
        --__pk-btn-border-color: var(--pk-btn-border-color, var(--__pk-btn-bg-color));
        --__pk-btn-color: var(--pk-btn-color, black);

        --__pk-btn-hover-color-mult: var(--pk-btn-hover-color-mult, 0.8);
        --__pk-btn-border-color-hover: var(--pk-btn-border-color-hover, color(from var(--__pk-btn-border-color) xyz calc(x * var(--__pk-btn-hover-color-mult)) calc(y * var(--__pk-btn-hover-color-mult)) calc(z * var(--__pk-btn-hover-color-mult))));
        --__pk-btn-bg-color-hover: var(--pk-btn-bg-color-hover, color(from var(--__pk-btn-bg-color) xyz calc(x * var(--__pk-btn-hover-color-mult)) calc(y * var(--__pk-btn-hover-color-mult)) calc(z * var(--__pk-btn-hover-color-mult))));
        --__pk-btn-color-hover: var(--pk-btn-color-hover, var(--pk-btn-color));

        cursor: pointer;
        padding: 0.5rem 1rem;
        border: 1px solid var(--__pk-btn-border-color);
        background-color: var(--__pk-btn-bg-color);
        color: var(--__pk-btn-color, black);
        border-radius: var(--pk-border-radius);
        font-weight: 700;
        text-decoration: none;

        pk-icon {
            position: relative;
            top: 1px;
            --pk-icon-size: 1.8ch;
        }
    }

    .btn:hover,
    .btn:focus, 
    .btn:active {
        border-color: var(--__pk-btn-border-color-hover);
        background-color: var(--__pk-btn-bg-color-hover);
        color: var(--__pk-btn-color-hover);
    }

    .btn[disabled] {
        opacity: 0.7;
        --pk-btn-border-color-hover: var(--pk-btn-border-color);
        --pk-btn-bg-color-hover: var(--pk-btn-bg-color);
        --pk-btn-color-hover: var(--pk-btn-color);
        cursor: default;
    }

    .btn.btn-lg {
        padding: 0.75rem 1.5rem;
    }

    .btn.btn-primary {
        --pk-btn-bg-color: var(--pk-primary-500);
        --pk-btn-hover-color-mult: 0.6;
        --pk-btn-color: white;
    }

    .btn.btn-raised {
        --pk-btn-bg-color: white;
        --pk-btn-border-color: var(--pk-gray-300);
        box-shadow: var(--pk-box-shadow);
    }

    .btn.btn-rounded {
        border-radius: 50%;
    }

    .btn.btn-icon {
        padding: 0;
        width: 1.2rem;
        height: 1.2rem;
        line-height: 1.3rem;
        vertical-align: middle;
        text-align: center;
    }

    .btn.btn-block {
        display: block;
    }
    
    .btn.btn-link {
        display: inline;
        background: none;
        border: none;
        text-decoration: underline;
        font-weight: normal;
        margin: 0;
        padding: 0;
    }
    
    .pk-input {
        border-radius: var(--pk-input-border-radius);
        padding: var(--pk-input-padding);
        display: block;
        width: 100%;
        border: 1px solid var(--pk-input-border-color);
        color: var(--pk-input-color);
        background: var(--pk-input-background);
        font-size: var(--pk-input-font-size);
        line-height: normal;
        
        &:focus {
            border-color: var(--pk-input-active-color);
            box-shadow: 0 0 0 .25rem color(from var(--pk-input-active-color) xyz calc(x * 1.3) calc(y * 1.3) calc(z * 1.3) / 0.3)
        }

        &[disabled] {
            background: var(--pk-input-disabled-background);
        }
    }

    .pk-heading {
        font-size: 1.07em;
        font-weight: 700;
    }
    
    .mt-xs {
        margin-top: 0.25rem;
    }

    .mt-sm {
        margin-top: 0.5rem;
    }

    .mt {
        margin-top: 1rem;
    }
    
    .mt-md {
        margin-top: 1.5rem;
    }

    .mt-lg {
        margin-top: 2rem;
    }

    .mb-xs {
        margin-top: 0.25rem;
    }

    .mb-sm {
        margin-top: 0.5rem;
    }

    .mb {
        margin-top: 1rem;
    }

    .mb-md {
        margin-top: 1.5rem;
    }

    .mb-lg {
        margin-top: 2rem;
    }

    .d-flex {
        display: flex;
    }
    
    .d-inline-flex {
        display: inline-flex;
    }
    
    .d-flex-column {
        display: flex;
        flex-direction: column;
    }
    
    .align-items-center {
        align-items: center;
    }
    
    .flex-grow-1 {
        flex-grow: 1;
    }
    
    .gap-xs {
        gap: 0.25rem;
    }
    
    .gap-sm {
        gap: 0.5rem;
    }
    
    .gap {
        gap: 1rem;
    }
        
    .gap-md {
        gap: 1.5rem;
    }
            
    .gap-lg {
        gap: 2rem;
    }

`;
