import {GenericProvider} from "./generic-provider.js?ver=2.5.1";

export class SenderAddressesProvider extends GenericProvider {
    constructor() {
        super({
            name: 'senderAddresses',
            endpoint: '/polkurier/addresses',
        });
    }

    getSenderAddresses() {
        return this.filter(a => a.cover_address === false);
    }

    getDefaultSenderAddress() {
        const addresses = this.getSenderAddresses();
        return this.find(a => a.default === true) || addresses[0];
    }

    getCoverAddresses() {
        return this.filter(a => a.cover_address === true);
    }

    getDefaultCoverAddress() {
        const addresses = this.getCoverAddresses();
        return addresses.find(a => a.default === true) || addresses[0];
    }

}
