

export const POINT_LABELS = {
    INPOST: 'Samodzielnie dostarczę do punktu',
    INPOST_PACZKOMAT: 'Samodzielnie dostarczę do dowolnego paczkomatu',
    INPOST_PACZKOMAT_ALLEGRO: 'Samodzielnie dostarczę do dowolnego paczkomatu',
    INPOST_PACZKOMAT_ECONOMY: 'Samodzielnie dostarczę do dowolnego paczkomatu',
    INPOST_PACZKOMAT_KURIER: 'Samodzielnie dostarczę do dowolnego paczkomatu',
    INPOST_INTERNATIONAL: 'Samodzielnie dostarczę do dowolnego paczkomatu',
    POCZTEX_PUNKT: 'Samodzielnie dostarczę do placówki Poczty Polskiej',
    POCZTEX_PUNKT_PUNKT: 'Samodzielnie dostarczę do placówki Poczty Polskiej',
    PACZKA_W_RUCHU: 'Samodzielnie dostarczę punktu',
    DPD_POINT: 'Samodzielnie dostarczę do punktu.',
    DHL_POINT: 'Samodzielnie dostarczę do punktu POP',
    UPS_AP_POINT_POINT: 'Samodzielnie dostarczę do punktu UPS',
    UPS_AP_POINT_COURIER: 'Samodzielnie dostarczę do punktu UPS',
    DEFAULT: 'Samodzielnie dostarczę przesyłkę do punktu nadań lub przekażę kurierowi'
};

export function getPointLabel(courier) {
    return POINT_LABELS[courier] || POINT_LABELS.DEFAULT;
}

export const REQUIRE_SENDER_POINT = {
    POCZTEX_PUNKT: true,
    POCZTEX_PUNKT_PUNKT: true,
    POCZTEX_PUNKT_ALLEGRO: true,
    POCZTEX_PUNKT_PUNKT_ALLEGRO: true,
    DPD_POINT: true,
    UPS_AP_POINT_POINT: true,
    UPS_AP_POINT_COURIER: true,
};

export function isSenderPointRequired(courierId) {
    return REQUIRE_SENDER_POINT[courierId] || false;
}

const SAME_COURIERS_MAP = {
    INPOST_PACZKOMAT_ALLEGRO: 'INPOST_PACZKOMAT',
    INPOST_PACZKOMAT_KURIER: 'INPOST_PACZKOMAT',
    INPOST_PACZKOMAT_ECONOMY: 'INPOST_PACZKOMAT',
    INPOST_INTERNATIONAL: 'INPOST_PACZKOMAT',
    DPD_COURIER_POINT: 'DPD_POINT',
    POCZTEX_PUNKT_PUNKT: 'POCZTEX_PUNKT',
    POCZTEX_PUNKT_ALLEGRO: 'POCZTEX_PUNKT',
    POCZTEX_PUNKT_PUNKT_ALLEGRO: 'POCZTEX_PUNKT',
    POCZTEX_KURIER_PUNKT: 'POCZTEX_PUNKT',
    UPS_AP_COURIER_POINT: 'UPS_AP_POINT_POINT',
    UPS_AP_POINT_COURIER: 'UPS_AP_POINT_POINT',
};

export const getBaseCourier = courier => {
    return SAME_COURIERS_MAP[courier] || courier;
};

