import {ajaxRequest} from "./http.js?ver=2.5.1";

let mapToken;

export async function getMapToken() {
    if (mapToken === undefined) {
        mapToken = ajaxRequest('/polkurier/map/token');
    }

    if (mapToken instanceof Promise) {
        mapToken = (await mapToken)?.token || '';
    }
    return mapToken;
}

export async function openMapModal(options = {}) {
    const map = new POLKURIER.PointsMap({
        token: await getMapToken(),
        ...options,
    });

    map.showMapDialog();
    return new Promise((resolve) => {
        let selectedPoint;

        map.onConfirm((point) => {
            selectedPoint = point;
            map.closeMapDialog();
        });

        map.on('dialog:open', () => {
            if (typeof options.onOpen === 'function') {
                options.onOpen(map);
            }
        });

        map.on('dialog:closed', () => {
            resolve(selectedPoint);
        });
    });
}
