<?php

namespace Polkurier\Controller;

use Polkurier\Http\Request;
use Polkurier\Logger;
use Polkurier\Polkurier;

class CheckoutController extends AbstractStoreUpdateController
{

    /**
     * @used
     */
    protected function select_delivery_point(Request $request): void
    {
        $pointId = $request->request->getString('id');
        if (!empty($pointId)) {
            $point = [
                'id' => sanitize_text_field($pointId),
                'provider' => sanitize_text_field($request->request->getString('provider')),
                'type' => sanitize_text_field($request->request->getString('type')),
                'address' => sanitize_text_field($request->request->getString('address')),
                'cod' => $request->request->get('cod') === true,
                'label' => sanitize_textarea_field($request->request->getString('label')),
            ];
        } else {
            $point = null;
        }
        WC()->session->set(Polkurier::NAME . '_delivery_point', $point);
    }

    /**
     * @used
     */
    protected function set_payment_method(Request $request): void
    {
        WC()->session->set('chosen_payment_method', $request->request->getString('method'));
    }

}
