<?php

namespace Polkurier\Controller;


use Exception;
use Polkurier\AddressBook\AddressBookManager;
use Polkurier\ApiClient;
use Polkurier\CourierMessageManager;
use Polkurier\CouriersManager;
use Polkurier\Http\RedirectResponse;
use Polkurier\Http\Request;
use Polkurier\Http\Response;
use Polkurier\MapsTokenManager;
use Polkurier\Normalizer\Normalizer;
use Polkurier\Order\Order;
use Polkurier\Order\OrderAddress;
use Polkurier\Order\OrderCod;
use Polkurier\Order\OrderCreator;
use Polkurier\Order\OrderManager;
use Polkurier\Order\OrderPack;
use Polkurier\Order\OrderPickup;
use Polkurier\OrderStatusUpdater;
use Polkurier\Polkurier;
use Polkurier\ShipmentTemplate\ShipmentTemplateManager;
use Polkurier\Util\Notice;
use Polkurier\Util\Numbers;
use Polkurier\Util\ParameterBag;
use Polkurier\View;
use Throwable;

class PackageCreateController
{

    /**
     * @used
     */
    public function createAction(): Response
    {

        $request = new Request();
        if ($request->isPost()) {
            $order = $this->createOrder($request);
            if ($order->getOrderNumber() !== '') {
                return new RedirectResponse('admin.php?page=polkurier_packages&action=list');
            }
        }


//        $order = null;
//        if ($request->query->getInt('order_id') > 0) {
////    $isOrderDefined = (new OrderManager())->hasOrderDefined((int)$_GET['order_id']);
//            $order = (new OrderManager())->getOrderById((int)$_GET['order_id']);
//        }


        return new Response(View::render('PackageCreate/create', [
            'request' => $request,
            'isOrderDefined' => (new OrderManager())->hasOrderDefined($request->query->getInt('order_id')),
            'couriers' => (new CouriersManager())->getAll(),
            'couriersMessagesManager' => new CourierMessageManager(),
            'templates' => (new ShipmentTemplateManager())->getAll(),
            'mapToken' => (new MapsTokenManager())->getToken(),
            'addressBook' => new AddressBookManager(),
        ]));
    }



    private function createOrder(Request $request): Order
    {
        $props = $request->request;

        $createAddress = static function (ParameterBag $data, $pointId = '', $pointName = '') {
            $address = new OrderAddress();
            $address->company = $data->getString('company');
            $address->person = $data->getString('person');
            $address->street = $data->getString('street');
            $address->housenumber = $data->getString('housenumber');
            $address->flatnumber = $data->getString('flatnumber');
            $address->postcode = $data->getString('postcode');
            $address->city = $data->getString('city');
            $address->email = $data->getString('email');
            $address->phone = $data->getString('phone');
            $address->country = $data->getString('country');
            if (!empty($pointId) && $pointId !== '---') {
                $address->point_id = $pointId;
                $address->point_name = trim($pointName);
            }
            return $address;
        };

        $addressBook = new AddressBookManager();
        $normalizer = new Normalizer();
        $senderAddressData = $addressBook->getById($props->getString('polkurier_address'));
        $coverAddressData = $addressBook->getById($props->getString('polkurier_cover_address'));
        $pickupTime = explode('-', $props->getString('polkurier_pickup_date'));

        $packagesList = null;
        if (isset($_POST['packages_list'])) {
            $packagesList = json_decode(stripslashes($_POST['packages_list']), true, JSON_UNESCAPED_SLASHES);
        }

        $order = (new Order())
            ->setShopOrderId($props->getInt('order_id'))
            ->setCourier($props->getString('polkurier_carrier_id'))
            ->setShipmentType($props->getString('polkurier_type'))
            ->setDescription($props->getString('polkurier_description'))
            ->setSender($createAddress(
                new ParameterBag($normalizer->normalize($senderAddressData)),
                $props->getString('sender_machinename'),
                $props->getString('sender_point_name')
            ))
            ->setRecipient($createAddress(
                new ParameterBag($props->getArray('recipient')),
                $props->getString('recipient_machinename'),
                $props->getString('recipient_point_name')
            ))
            ->setCoverAddress($coverAddressData ? $createAddress(new ParameterBag($normalizer->normalize($coverAddressData))) : null)
            ->setPacks(array_map(static function (array $row) {
                $pack = new OrderPack();
                $pack->length = (int)Numbers::ensureDigits($row['depth'] ?? '');
                $pack->width = (int)Numbers::ensureDigits($row['width'] ?? '');
                $pack->height = (int)Numbers::ensureDigits($row['height'] ?? '');
                $pack->weight = (float)Numbers::ensureDigits($row['weight'] ?? '');
                $pack->amount = (int)Numbers::ensureDigits($row['count'] ?? '');
                $pack->type = (string)($row['type'] ?? 'ST');
                return $pack;
            }, $packagesList))
            ->setPickup(new OrderPickup(
                $props->getString('polkurier_date'),
                $pickupTime[0] ?? null,
                $pickupTime[1] ?? null,
                $props->getString('polkurier_pickup_type') === 'SELF_PICKUP'
            ))
            ->setCod(new OrderCod(
                (float)Numbers::ensureDigits($props->get('polkurier_pobranie')),
                (string)$props->get('polkurier_pobranie_zwrot'),
                (string)$props->get('polkurier_pobranie_rodzaj'),
                (string)$props->get('polkurier_account')
            ))
            ->setInsurance((float)Numbers::ensureDigits($props->get('polkurier_ubezpieczenie')));

        foreach ($props->getArray('courierservice') as $service => $enabled) {
            if ((int)$enabled === 1) {
                $order->setCourierService($service);
            }
        }

        try {
            (new OrderCreator())->create($order);
        } catch (Throwable $e) {
            Notice::error($e->getMessage());
        }

        return $order;
    }

}
