<?php

namespace Polkurier\Controller;


use Exception;
use Polkurier\ApiClient;
use Polkurier\CouriersManager;
use Polkurier\Http\RedirectResponse;
use Polkurier\Http\Request;
use Polkurier\Http\Response;
use Polkurier\Order\OrderManager;
use Polkurier\OrderStatusUpdater;
use Polkurier\View;

class PackagesListController
{

    public function listAction(): Response
    {
        $request = new Request();
        if ($request->query->has('update_all_statuses')) {
            try {
                $statusUpdater = new OrderStatusUpdater();
                $statusUpdater->updateAllOrdersStatuses();
            } catch (Exception $e) {
                return new Response(View::render('error', ['message' => $e->getMessage()]));
            }
            return new RedirectResponse('admin.php?page=polkurier_packages&did_update_all_statuses');
        }

        return new Response(View::render('PackagesList/packages-list', [
            'request' => $request,
        ]));
    }

    public function detailsAction(): Response
    {
        $request = new Request();
        $order = (new OrderManager())->getOrderByNumber($request->query->getString('label'));
        if ($order === null) {
            return new Response(View::render('error', ['message' => 'Nieznana przesyłka']));
        }

        $statusUpdater = new OrderStatusUpdater();
        $statusUpdater->updateOrderStatus($order);

        return new Response(View::render('PackagesList/details', [
            'order' => $order,
            'courier' => (new CouriersManager())->get($order->getCourier()),
        ]));
    }

    public function cancelAction(): Response
    {
        try {
            $response = (new ApiClient())->makeApiRequest('cancel_order', [
                'orderno' => (new Request())->query->getString('package'),
            ]);
            if (isset($response['cancellation']) && $response['cancellation'] === true) {
                (new OrderManager())->deleteByOrderNumber((string)$_GET['package']);
                return new RedirectResponse('admin.php?page=polkurier_packages&did_cancel_order=1');
            }
        } catch (Exception $e) {
            return new Response(View::render('error', ['message' => $e->getMessage()]));
        }
        return new Response(View::render('error', ['message' => 'Nie udało się anulować przesyłki']));
    }

}
