<?php

namespace Polkurier\Controller;


use Polkurier\AddressBook\Address;
use Polkurier\AddressBook\AddressBookManager;
use Polkurier\Http\Request;
use Polkurier\Http\Response;
use Polkurier\View;

class SettingsAddressesController
{

    private function indexAction(string $type): Response
    {
        $request = new Request();
        $isCoverAddress = $type === 'cover_addresses';
        $manager = new AddressBookManager();

        if ($request->query->getString('action') === 'delete') {
            $address = $manager->getById($request->query->getString('id'));
            if ($address !== null) {
                $manager->remove($address);
                $manager->save();
            }
        } else if ($request->isPost()) {
            $address = $manager->getById($request->request->getString('id'));
            if ($address === null) {
                $address = new Address();
                $address->cover_address = $isCoverAddress;
                $manager->persist($address);
            }

            $address->company = $request->request->getString('company');
            $address->person = $request->request->getString('person');
            $address->street = $request->request->getString('street');
            $address->housenumber = $request->request->getString('housenumber');
            $address->flatnumber = $request->request->getString('flatnumber');
            $address->postcode = $request->request->getString('postcode');
            $address->city = $request->request->getString('city');
            $address->phone = $request->request->getString('phone');
            $address->email = $request->request->getString('email');
            $address->account_id = $request->request->getString('account_id');

            if ($request->request->getBoolean('default')) {
                $manager->setDefault($address);
            }
            $manager->save();
        }

        if ($isCoverAddress) {
            $items = $manager->getCoverAddresses();
        } else {
            $items = $manager->getSenderAddresses();
        }

        $currentAddress = $manager->getById($request->query->getString('id'));
        if ($currentAddress === null) {
            $currentAddress = new Address();
        }

        return new Response(View::render('settings/addresses', [
            'tab' => $request->query->getString('tab'),
            'items' => $items,
            'currentAddress' => $currentAddress,
        ]));
    }

    /**
     * @used
     */
    public function senderAddressesAction(): Response
    {
        return $this->indexAction('sender_addresses');
    }

    /**
     * @used
     */
    public function coverAddressesAction(): Response
    {
        return $this->indexAction('cover_addresses');
    }

}
