<?php

namespace Polkurier\Controller;


use Polkurier\BankAccounts\BankAccount;
use Polkurier\BankAccounts\BankAccountsManager;
use Polkurier\CouriersManager;
use Polkurier\Http\Request;
use Polkurier\Http\Response;
use Polkurier\ShipmentTemplate\ShipmentTemplate;
use Polkurier\ShipmentTemplate\ShipmentTemplateManager;
use Polkurier\Util\Numbers;
use Polkurier\View;

class SettingsShipmentTemplatesController
{

    /**
     * @used
     */
    public function indexAction(): Response
    {
        $manager = new ShipmentTemplateManager();
        $couriersManager = new CouriersManager();
        $request = new Request();

        if ($request->query->getString('action') === 'delete') {
            $template = $manager->getById($request->query->getString('id'));
            if ($template !== null) {
                $manager->remove($template);
                $manager->save();
            }
        } else if ($request->isPost()) {
            $template = $manager->getById($request->request->getString('id'));
            if ($template === null) {
                $template = new ShipmentTemplate();
            }

            $template->name = $request->request->getString('name');
            $template->courier = $request->request->getString('courier');
            $template->width = $request->request->getFloat('width');
            $template->height = $request->request->getFloat('height');
            $template->length = $request->request->getFloat('length');
            $template->weight = $request->request->getFloat('weight');
            $template->amount = $request->request->getInt('amount');
            $template->default = $request->request->getBoolean('default');

            $type = explode('::', $request->request->getString('type'));
            $template->shipment_type = $type[0];
            $template->type = $type[1];

            $manager->persist($template);
            if ($template->default) {
                $manager->setDefault($template);
            }
            $manager->save();
        }

        return new Response(View::render('settings/templates', [
            'tab' => $request->query->getString('tab'),
            'items' => $manager->getAll(),
            'template' => $manager->getById($request->query->getString('id')) ?? new ShipmentTemplate(),
            'couriersManager' => $couriersManager,
        ]));
    }

}
