<?php


namespace Polkurier\Http;


use Polkurier\Util\ParameterBag;

class Request
{

    public ParameterBag $query;
    public ParameterBag $request;
    public string $method;

    /**
     * Response constructor.
     */
    public function __construct(?array $request = null, ?array $query = null, ?string $method = null)
    {
        $this->request = new ParameterBag($request ?? $_POST);
        $this->query = new ParameterBag($query ?? $_GET);
        $this->method = $method ?? $_SERVER['REQUEST_METHOD'];
    }

    public function getMethod(): string
    {
        return $this->method;
    }

    public function isPost(): bool
    {
        return $this->method === 'POST';
    }

}
