<?php

namespace Polkurier;

class MapsToken
{

    private string $token = '';
    private bool $isValid = false;
    private array $header = [];
    private array $payload = [];
    private string $signature = '';

    public function __construct(string $token = '')
    {
        $this->parseToken($token);
    }

    /**
     * @return string
     */
    public function __toString()
    {
        return $this->token;
    }

    private function parseToken(string $token): void
    {
        $this->token = $token;
        $this->header = [];
        $this->payload = [];
        $this->signature = '';
        $this->isValid = false;

        if (substr_count($this->token, '.') !== 2) {
            return;
        }

        [$header, $payload, $signature] = explode('.', $this->token);
        if (!empty($header)) {
            $header = json_decode(base64_decode($header), true);
            if (is_array($header) && json_last_error() === JSON_ERROR_NONE) {
                $this->header = $header;
            } else {
                $this->isValid = false;
                return;
            }
        }

        if (!empty($payload)) {
            $payload = json_decode(base64_decode($payload), true);
            if (is_array($payload) && json_last_error() === JSON_ERROR_NONE) {
                $this->payload = $payload;
            } else {
                $this->isValid = false;
                return;
            }
        }

        $this->signature = $signature;
        $this->isValid = true;
    }


    public function getExp(): int
    {
        return (int)($this->payload['exp'] ?? 0);
    }

    public function isExpired(): bool
    {
        return $this->getExp() < time();
    }

    public function isValid(): bool
    {
        return $this->isValid && !$this->isExpired();
    }

    public function getToken(): string
    {
        return $this->token;
    }

    public function getHeader(): array
    {
        return $this->header;
    }

    public function getPayload(): array
    {
        return $this->payload;
    }

    public function getSignature(): string
    {
        return $this->signature;
    }

}
