<?php

namespace Polkurier\ShipmentTemplate;

use Polkurier\AbstractSimpleObjectManager;
use Polkurier\Types\PackType;
use Polkurier\Types\ShipmentType;
use Polkurier\Util\Arr;

/**
 * @extends AbstractSimpleObjectManager<ShipmentTemplate>
 */
class ShipmentTemplateManager extends AbstractSimpleObjectManager
{

    public function setDefault(ShipmentTemplate $template): ShipmentTemplateManager
    {
        foreach ($this->getAll() as $t) {
            $t->default = $t === $template;
        }
        return $this;
    }

    public function fromArray(array $data): object
    {
        $template = new ShipmentTemplate();
        if (!empty($data['id'])) {
            $template->id = $data['id'];
        }
        $template->name = (string)Arr::get($data, 'name');
        $template->courier = (string)Arr::get($data, 'courier');
        $template->height = (float)Arr::get($data, 'height');
        $template->width = (float)Arr::get($data, 'width');
        $template->length = (float)Arr::get($data, 'length');
        $template->weight = (float)Arr::get($data, 'weight');
        $template->amount = (int)Arr::get($data, 'amount');
        $template->default = (bool)Arr::get($data, 'default');
        $template->type = (string)Arr::get($data, 'type', PackType::ST);

        switch ((string)Arr::get($data, 'shipment_type')) {
            case 'koperta':
            case 'envelope':
            case ShipmentType::ENVELOPE:
                $template->shipment_type = ShipmentType::ENVELOPE;
                $template->type = PackType::ST;
                break;

            case 'paleta':
            case 'palette':
            case ShipmentType::PALETTE:
                $template->shipment_type = ShipmentType::PALETTE;
                break;

            default:
                $template->shipment_type = ShipmentType::BOX;
        }

        return $template;
    }

    protected function getWPOptionName(): string
    {
        return 'polkurier_shipment_templates';
    }

}
