<?php

namespace Polkurier\ShippingMethods;


class DpdShippingMethodMethod extends AbstractShippingMethod
{

    protected function getDefaultTitle(): string
    {
        return 'DPD Pickup';
    }

    public function getId(): string
    {
        return 'pk_dpd_point';
    }

    public function getPolkurierId(): string
    {
        return 'DPD_POINT';
    }

    public function isParcelPickupPoint(): bool
    {
        return true;
    }

    public function getSelectButtonLabel(): string
    {
        return __('Wybierz punkt', 'polkurier');
    }

    public function getSelectedPointLabel(): string
    {
        return __('Wybrany punkt', 'polkurier');
    }

    protected function getErrorMessages(): array
    {
        return [
            self::ERROR_MESSAGE_NOT_POINT_SELECTED => __('Nie wybrano punktu', 'polkurier'),
            self::ERROR_MESSAGE_NO_PHONE_NUMBER => __('Numer telefonu jest wymagany', 'polkurier'),
        ];
    }

}
