<?php

namespace Polkurier\ShippingMethods;

class PaczkaWRuchuShippingMethodMethod extends AbstractShippingMethod
{

    protected function getDefaultTitle(): string
    {
        return 'ORLEN Paczka';
    }

    public function getId(): string
    {
        return 'pk_paczka_w_ruchu';
    }

    public function getPolkurierId(): string
    {
        return 'PACZKA_W_RUCHU';
    }

    public function isParcelPickupPoint(): bool
    {
        return true;
    }

    public function getSelectButtonLabel(): string
    {
        return __('Wybierz punkt ORLEN', 'polkurier');
    }

    public function getSelectedPointLabel(): string
    {
        return __('Wybrany punkt ORLEN', 'polkurier');
    }

    protected function getErrorMessages(): array
    {
        return [
            self::ERROR_MESSAGE_NOT_POINT_SELECTED => __('Nie wybrano punktu ORLEN', 'polkurier'),
            self::ERROR_MESSAGE_NO_PHONE_NUMBER => __('Numer telefonu jest wymagany', 'polkurier'),
        ];
    }

}
