<?php

namespace Polkurier\Types;

class CheckoutPointButtonPosition
{

    public const AFTER_SHIPPING_BLOCK = '';
    public const AFTER_SELECTED_METHOD = 'AFTER_SELECTED_METHOD';
    public const AFTER_SHIPPING_RATE = 'woocommerce_after_shipping_rate';
    public const REVIEW_ORDER_BEFORE_SUBMIT = 'woocommerce_review_order_before_submit';
    public const REVIEW_ORDER_BEFORE_ORDER_TOTAL = 'woocommerce_review_order_before_order_total';
    public const REVIEW_ORDER_AFTER_ORDER_TOTAL = 'woocommerce_review_order_after_order_total';
    public const REVIEW_ORDER_AFTER_SHIPPING = 'woocommerce_review_order_after_shipping';
    public const REVIEW_ORDER_BEFORE_SHIPPING = 'woocommerce_review_order_before_shipping';
    public const REVIEW_ORDER_AFTER_SUBMIT = 'woocommerce_review_order_after_submit';

    public const VALID_POSITIONS = [
        self::AFTER_SELECTED_METHOD,
        self::AFTER_SHIPPING_RATE,
        self::REVIEW_ORDER_BEFORE_SUBMIT,
        self::REVIEW_ORDER_BEFORE_ORDER_TOTAL,
        self::REVIEW_ORDER_AFTER_ORDER_TOTAL,
        self::REVIEW_ORDER_AFTER_SHIPPING,
        self::REVIEW_ORDER_BEFORE_SHIPPING,
        self::REVIEW_ORDER_AFTER_SUBMIT,
    ];

    public const MAP_POSITIONS = [
        self::AFTER_SELECTED_METHOD => 'woocommerce_after_shipping_rate',
    ];

    public const NAMES = [
        self::AFTER_SHIPPING_BLOCK => 'Pod blokiem wszystkich metod dostawy (domyślnie)',
        self::AFTER_SELECTED_METHOD => 'Pod wybraną metodą dostawy',
        self::AFTER_SHIPPING_RATE => 'Za wybraną metodą dostawy',
        self::REVIEW_ORDER_BEFORE_SUBMIT => 'Przed przyciskiem "Złóż zamówienie"',
        self::REVIEW_ORDER_BEFORE_ORDER_TOTAL => 'Przed informacją o łącznej kwocie',
        self::REVIEW_ORDER_AFTER_ORDER_TOTAL => 'Po informacji o łącznej kwocie zamówienia',
        self::REVIEW_ORDER_AFTER_SHIPPING => 'Po opisaniu metod',
        self::REVIEW_ORDER_BEFORE_SHIPPING => 'Przed opisem metod dostaw',
        self::REVIEW_ORDER_AFTER_SUBMIT => 'Po przycisku "Złóż zamówienie"',
    ];

    public const MAP_TEMPLATE = [
        self::AFTER_SHIPPING_BLOCK => 'checkout/review-order-after-shipping.php',
        self::REVIEW_ORDER_BEFORE_SHIPPING => 'checkout/review-order-after-shipping.php',
        self::REVIEW_ORDER_AFTER_SHIPPING => 'checkout/review-order-after-shipping.php',
        self::REVIEW_ORDER_BEFORE_ORDER_TOTAL => 'checkout/review-order-after-shipping.php',
        self::REVIEW_ORDER_AFTER_ORDER_TOTAL => 'checkout/review-order-after-shipping.php',
    ];

    public const DEFAULT_PRIORITY = 10;
    public const PRIORITIES = [
        self::AFTER_SHIPPING_RATE => 1,
    ];

}
