<?php

namespace Polkurier\Upgrade\Migrations;

use Polkurier\ConfigManager;
use Polkurier\Types\ConfigType;
use Polkurier\Upgrade\DatabaseMigrationAlwaysInterface;

class EnsureInstallationId implements DatabaseMigrationAlwaysInterface
{

    public function doUpgrade(): void
    {
        $config = new ConfigManager();
        if (empty($config->getString(ConfigType::INSTALLATION_ID))) {
            $config->set(ConfigType::INSTALLATION_ID, wp_generate_uuid4());
        }
    }

}
