<?php

namespace Polkurier\Upgrade\Migrations;

use Polkurier\Upgrade\DatabaseMigrationAlwaysInterface;

class EnsureOrderPointTable implements DatabaseMigrationAlwaysInterface
{

    public function doUpgrade(): void
    {
        global $wpdb;
        $wpdb->query("
            CREATE TABLE IF NOT EXISTS {$wpdb->prefix}polkurier_shipping_points (
              id int(11) NOT NULL AUTO_INCREMENT,
              wp_order_id int(11) NOT NULL,
              code varchar(100) NOT NULL DEFAULT '',
              label varchar(1000) NOT NULL DEFAULT '',
              provider varchar(100) NOT NULL DEFAULT '',
              type varchar(100) DEFAULT '',
              PRIMARY KEY  (id),
              KEY wp_polkurier_shipping_points_wp_order_id_IDX (wp_order_id) USING BTREE,
              KEY wp_polkurier_shipping_points_code_IDX (code) USING BTREE
            ) ENGINE=InnoDB {$wpdb->get_charset_collate()};
        ");
    }

}
