<?php

namespace Polkurier\Upgrade\Migrations;

use Polkurier\Upgrade\DatabaseMigrationAlwaysInterface;

class EnsureOrdersTable implements DatabaseMigrationAlwaysInterface
{

    public function doUpgrade(): void
    {
        global $wpdb;
        $wpdb->query("
            CREATE TABLE IF NOT EXISTS {$wpdb->prefix}polkurier_orders (
                id int(11) NOT NULL AUTO_INCREMENT,
                wp_order_id int(11) DEFAULT NULL,
                order_number varchar(55) NULL,
                label text NULL,
                price_gross decimal(20,2) DEFAULT '0.00' NOT NULL,
                price_net decimal(20,2) DEFAULT '0.00' NOT NULL,
                carrier varchar(255) DEFAULT '' NOT NULL,
                address text NULL,
                address_to text NULL,
                pobranie decimal(20,2) DEFAULT '0.00' NOT NULL,
                status_code varchar(10) DEFAULT '' NOT NULL,
                delivered_date datetime NULL DEFAULT NULL,
                extra text NULL,
                date_created DATETIME NULL,
                KEY wp_order_id (wp_order_id),
                KEY order_number (order_number),
                PRIMARY KEY (id)
            ) {$wpdb->get_charset_collate()};
        ");
    }

}
