<?php

namespace Polkurier\Upgrade\Migrations;

use Polkurier\Upgrade\DatabaseMigrationInterface;

class MigrateFrom0To1 implements DatabaseMigrationInterface
{

    public function fromVersion(): int
    {
        return 0;
    }

    public function toVersion(): int
    {
        return 1;
    }

    public function doUpgrade(): void
    {
        global $wpdb;
        $orders = get_option('polkurier_orders') ?: [];

        if (!empty($orders)) {
            foreach ((array)$orders as $order) {
                if (is_object($order)) {
                    $order = get_object_vars($order);
                } else {
                    $order = (array)$order;
                }

                if (empty($order)) {
                    continue;
                }

                if (!empty($order['params']['address']) && is_object($order['params']['address'])) {
                    $order['params']['address'] = get_object_vars($order['params']['address']);
                }

                if (!empty($order['params']['address_to']) && is_object($order['params']['address_to'])) {
                    $order['params']['address_to'] = get_object_vars($order['params']['address_to']);
                }

                $wpdb->insert($wpdb->prefix . 'polkurier_orders', [
                    'wp_order_id' => (int)$order['params']['wp_order_id'],
                    'order_number' => $order['params']['order_number'],
                    'label' => json_encode((array)($order['params']['label'] ?? [])),
                    'price_gross' => $order['params']['price_gross'],
                    'price_net' => $order['params']['price_net'],
                    'carrier' => $order['params']['carrier'] ?: '',
                    'address' => json_encode($order['params']['address']['address'] ?? []),
                    'address_to' => json_encode($order['params']['address_to']['address'] ?? []),
                    'pobranie' => $order['params']['pobranie'] ?: 0,
                    'extra' => json_encode($order['params']['extra'] ?? []),
                    'date_created' => date('Y-m-d H:i:s')
                ]);
            }
        }
    }

}
