<?php

namespace Polkurier\Upgrade\Migrations;

use Polkurier\ShipmentTemplate\ShipmentTemplateManager;
use Polkurier\Upgrade\DatabaseMigrationInterface;

class MigrateFrom8To9 implements DatabaseMigrationInterface
{

    public function fromVersion(): int
    {
        return 8;
    }

    public function toVersion(): int
    {
        return 9;
    }

    public function doUpgrade(): void
    {
        $templatesManager = new ShipmentTemplateManager();
        $oldTemplates = (array)get_option('polkurier_packages', []);
        foreach ($templatesManager->getAll() as $template) {
            if ($template->type === 'NST' && strpos($template->name, 'Bez nazwy') === 0) {
                $template->type = 'ST';
                $i = (int)substr($template->name, 10) - 1;
                if (isset($oldTemplates[$i])) {
                    $row = $oldTemplates[$i];
                    if (is_object($row)) {
                        $row = get_object_vars($row);
                    }
                    if (is_array($row)) {
                        $template->type = isset($row['nonstandard']) && (int)$row['nonstandard'] === 1 ? 'NST' : 'ST';
                    }
                }
            }
        }
        $templatesManager->save();
    }

}
