<?php

namespace Polkurier\Upgrade;

use Polkurier\PluginInfoProvider;
use Polkurier\Polkurier;
use stdClass;

class PluginUpgradeManager
{

    public function initialize(): void
    {
        add_filter('plugins_api', function ($result, $action, $args) {
            if ($action !== 'plugin_information' || Polkurier::SLUG !== $args->slug) {
                return $result;
            }

            $pluginInfo = (new PluginInfoProvider())->getUpdateInfo();
            if ($pluginInfo === null || $pluginInfo->version === '') {
                return $result;
            }

            $res = new stdClass();
            $res->name = 'Polkurier';
            $res->slug = Polkurier::SLUG;
            $res->author = 'Polkurier';
            $res->version = $pluginInfo->version;
            $res->tested = $pluginInfo->tested;
            $res->requires = $pluginInfo->getDependencyVersion('wordpress');
            $res->requires_php = $pluginInfo->getDependencyVersion('php');
            $res->download_link = $pluginInfo->package_url;
            $res->trunk = $pluginInfo->package_url;
            $res->last_updated = $pluginInfo->date->format(DATE_ATOM);
            $res->sections = [
                'changelog' => nl2br($pluginInfo->changelog),
            ];

            return $res;
        }, 20, 3);

        add_filter('site_transient_update_plugins', function ($transient) {
            if (empty($transient->checked)) {
                return $transient;
            }

            $pluginInfo = (new PluginInfoProvider())->getUpdateInfo();
            if ($pluginInfo === null || $pluginInfo->version === '') {
                return $transient;
            }

            if ($pluginInfo->isUpdateAvailable() && $pluginInfo->isUpdateCompatible()) {
                $res = new stdClass();
                $res->slug = Polkurier::SLUG;
                $res->plugin = Polkurier::SLUG;
                $res->new_version = $pluginInfo->version;
                $res->tested = $pluginInfo->tested;
                $res->package = $pluginInfo->package_url;
                $res->icons = [
                    'svg' => $pluginInfo->icon_url,
                ];
                $transient->response[$res->plugin] = $res;
            }

            return $transient;
        });

        // After update
        add_action('upgrader_process_complete', function ($upgrader, $options) {
            if (
                $options['action'] === 'update' &&
                $options['type'] === 'plugin' &&
                isset($options['plugins']) &&
                in_array(Polkurier::SLUG, $options['plugins'], true)
            ) {
                (new PluginInfoProvider())->clearCache();
                (new DatabaseUpgrade())->doUpgrade();
            }
        }, 10, 2);
    }

}
