<?php

namespace Polkurier\Util;

final class Arr
{

    /**
     * @depecated
     */
    public static function get($arr, string $key, $default = null)
    {
        if (is_array($arr) && array_key_exists($key, $arr)) {
            return $arr[$key];
        }
        return $default;
    }

    public static function getByPath(array &$arr, string $path)
    {
        if (empty($path) || empty($arr)) {
            return null;
        }
        $pathParts = explode('.', $path);
        $value = $arr;
        while ($pathItem = array_shift($pathParts)) {
            if (is_array($value)) {
                $value = $value[$pathItem] ?? null;
            } else {
                break;
            }
        }
        return $value;
    }

    private static function getEntityValue($entity, $getter)
    {
        if (is_callable($getter)) {
            return $getter($entity);
        }

        if (is_scalar($entity)) {
            return $entity;
        }

        if (is_array($entity)) {
            return self::get($entity, $getter);
        }

        if (is_object($entity)) {
            if (method_exists($entity, $getter)) {
                return $entity->{$getter}();
            }
            $getterMethod = 'get' . ucfirst($getter);
            if (method_exists($entity, $getterMethod)) {
                return $entity->{$getterMethod}();
            }
            return $entity->{$getter};
        }
        return null;
    }

    public static function groupBy($arr, $groupBy): array
    {
        $data = [];
        if (is_array($arr)) {
            foreach ($arr as $item) {
                $key = self::getEntityValue($item, $groupBy);
                if (!array_key_exists($key, $data)) {
                    $data[$key] = [];
                }
                $data[$key][] = $item;
            }
        }
        return $data;
    }

    public static function indexBy($arr, $indexBy): array
    {
        $data = [];
        if (is_array($arr)) {
            foreach ($arr as $item) {
                $data[self::getEntityValue($item, $indexBy)] = $item;
            }
        }
        return $data;
    }

}
