<?php

namespace Polkurier\Util;

use DateTime;
use DateTimeImmutable;

class Dates
{

    /**
     * Format DateTime Dla MySQL
     * @example 2019-10-28 09:28:12
     */
    public const MYSQL_DATETIME = 'Y-m-d H:i:s';

    /**
     * Format Date Dla MySQL
     * @example 2019-10-28
     */
    public const MYSQL_DATE = 'Y-m-d';

    /**
     * Zwraca obiekt typu DateTime lub null, jeśli niepoprawna data
     */
    public static function dateTimeOrNull($date): ?DateTime
    {
        if ($date instanceof DateTime) {
            return $date;
        }

        // podano NULL — normalnie DateTime po podaniu wartości null tworzy obiekt z obecną datą, dla na NULL
        // jest pustą datę, więc zwracamy wartość NULL
        if (empty($date)) {
            return null;
        }

        try {
            // Jeśli wartość jest liczbą, to uznajemy, że to timestamp
            if (is_numeric($date)) {
                $date = '@' . $date;
            }
            return new \DateTime($date);
        } catch (\Exception $e) {
            return null;
        }
    }

    public static function dateTimeImmutableOrNull($date): ?DateTimeImmutable
    {
        $date = self::dateTimeOrNull($date);
        if ($date === null) {
            return null;
        }
        return DateTimeImmutable::createFromMutable($date);
    }

}
