<?php
if (!isset($shopOrderId)) {
    $shopOrderId = 0;
}
if (!isset($order)) {
    $order = null;
}
if (!isset($nonce)) {
    $nonce = '';
}
?>

<div id="pk-order-<?php echo $shopOrderId ?>-tracking" style="font-size: 12px; line-height: 1;">
    <?php if ($order): ?>
        <h4>Numer zamówienia</h4>
        <div>
            <a href="https://www.polkurier.pl/lista-zamowien?numer-zamowienia=<?php echo $order->getOrderNumber() ?>" target="_blank">
                <?php echo $order->getOrderNumber() ?>
            </a>
        </div>

        <h4>List przewozowy</h4>
        <?php foreach ($order->getLabel() as $label): ?>
            <div>
                <a href="https://www.polkurier.pl/sledzenie-przesylek?number=<?php echo $label ?>" target="_blank">
                    <?php echo $label ?>
                </a>
            </div>
        <?php endforeach; ?>
        <div style="display: flex; flex-direction: column; gap: 0.5rem; margin-top: 1.5rem; padding: 1rem 0;">
            <a
                href="admin.php?page=polkurier_packages&action=label&label=<?php echo $order->getOrderNumber() ?>&_wpnonce=<?php echo $nonce ?>"
                class="button polkurier-order-view-button"
                aria-label="Pobierz etykietę"
                target="_blank"
            >
                Pobierz etykietę
                <span class="dashicons dashicons-printer"></span>
            </a>
            <a
                href="admin.php?page=polkurier_packages&action=protocol&label=<?php echo $order->getOrderNumber() ?>&_wpnonce=<?php echo $nonce ?>"
                class="button polkurier-order-view-button"
                aria-label="Pobierz protokół"
                target="_blank"
            >
                Pobierz protokół
                <span class="dashicons dashicons-list-view"></span>
            </a>
        </div>
    <?php else: ?>
        <div style="display: flex; flex-direction: column; gap: 0.5rem; margin-top: 1.5rem; padding: 1rem 0;">
            <a
                href="admin.php?page=polkurier_packages&action=create&order_id=<?php echo $shopOrderId ?>&_wpnonce=<?php echo $nonce ?>"
                class="button wc-action-button-polkurier-quick polkurier-prevent-default polkurier-order-view-button"
                aria-label="Szybie zamówienie przesyłki"
            >
                Szybie zamówienie przesyłki
            </a>
            <a
                href="admin.php?page=polkurier_packages&action=create&order_id=<?php echo $shopOrderId ?>&_wpnonce=<?php echo $nonce ?>"
                class="button wc-action-button-polkurier polkurier-action-button polkurier-order-view-button"
                aria-label="Zamów przesyłkę"
            >
                Zamów przesyłkę
            </a>
        </div>
    <?php endif; ?>
</div>
