<?php

if (!defined('WPINC')) {
    die;
}

use Polkurier\CouriersManager;
use Polkurier\Models\Courier;
use Polkurier\Order\Order;
use Polkurier\Order\OrderAddress;
use Polkurier\Order\OrderManager;
use Polkurier\OrderStatusUpdater;
use Polkurier\Types\OrderStatusType;
use Polkurier\Types\PackType;
use Polkurier\Types\ShipmentType;

/** @var Order $order */
/** @var Courier|null $courier */

?>
    <h2>Szczegóły zamówienia Polkurier <?php echo $order->getOrderNumber() ?></h2>
    <table class="form-table">
        <tbody>
        <tr>
            <th scope="row"><label>Przewoźnik</label></th>
            <td><?php echo $courier !== null ? $courier->name : $order->getCourier() ?></td>
        </tr>
        <tr>
            <th scope="row"><label>Rodzaj przesyłki</label></th>
            <td><?php echo ShipmentType::getDisplayName($order->getShipmentType()) ?>
        </tr>
        <tr>
            <th scope="row"><label>Data nadania</label></th>
            <td>
                <?php
                    $pickup = $order->getPickup();
                    if ($pickup !== null) {
                        if ($pickup->noCourierOrder) {
                            echo 'Samodzielnie zamówienie kuriera lub dostarczenie do punktu';
                        } else {
                            echo $pickup->date !== null
                                ? $pickup->date->format('Y-m-d') . ($pickup->timeFrom !== null ? " $pickup->timeFrom — $pickup->timeTo" : "")
                                : '—';
                        }
                    }
                ?>
            </td>
        </tr>
        <tr>
            <th scope="row"><label>Paczki</label></th>
            <td>
                <ol>
                    <?php foreach ($order->getPacks() as $pack) {
                        $type = PackType::getDisplayName($pack->type, $order->getShipmentType());
                        echo "<li>$type, wymiary: {$pack->height}cm × {$pack->width}cm × {$pack->length}cm, waga: {$pack->weight}kg, ilość: $pack->amount</li>";
                    } ?>
                </ol>
            </td>
        </tr>
        <tr>
            <th scope="row"><label>Adres nadawcy</label></th>
            <td>
                <?php
                $printAddress = static function (?OrderAddress $address): void {
                    if ($address !== null) {
                        echo $address->company . "<br/>";
                        echo $address->person . "<br/>";
                        echo $address->street . " " . $address->housenumber . " " . ($address->flatnumber ? (" / $address->flatnumber") : '') . "<br/>";
                        echo $address->postcode . " " . $address->city . ' (' . ($address->country ?: 'PL') . ")<br/>";
                        echo $address->phone . " " . $address->email . '<br>';
                        echo !empty($address->point_id) ? 'Punkt nadania: ' . $address->point_name . ' (' . $address->point_id . ')' : '';
                    }
                };
                $printAddress($order->getSender());
                ?>
            </td>
        </tr>
        <tr>
            <th scope="row"><label>Adres odbiorcy</label></th>
            <td>
                <?php $printAddress($order->getRecipient()); ?>
            </td>
        </tr>
        <tr>
            <th scope="row"><label>Kwota pobrania</label></th>
            <td><?php echo $order->getCod() !== null && $order->getCod()->amount > 0 ? $order->getCod()->amount : 'brak' ?></td>
        </tr>
        <tr>
            <th scope="row"><label>Kwota ubezpieczenia</label></th>
            <td><?php echo $order->getInsurance() > 0 ? $order->getInsurance() : 'brak' ?></td>
        </tr>
        <tr>
            <th scope="row"><label>Status</label></th>
            <td>
                <?php
                echo OrderStatusType::getDisplayName($order->getStatusCode()) ?: $order->getStatusCode();
                if ($order->getStatusCode() === OrderStatusType::DELIVERED && $order->getDeliveredDate() !== null) {
                    echo ", data doręczenia: " . $order->getDeliveredDate()->format('Y-m-d H:i');
                }
                ?>
            </td>
        </tr>

        </tbody>
    </table>
<?php
if (wp_get_referer()) {
    echo '<a href="' . wp_get_referer() . '" >Wstecz</a>';
} else {
    echo '<a href="admin.php?page=polkurier_packages">Wstecz</a>';
}
