<?php
if (!defined('WPINC')) {
    die;
}

use Polkurier\BankAccounts\BankAccount;
use Polkurier\BankAccounts\BankAccountsManager;
use Polkurier\Http\Request;
use Polkurier\View;

$request = new Request();
$manager = new BankAccountsManager();

/** @var string $tab */
/** @var BankAccount[] $items */
/** @var BankAccount $bankAccount */


echo View::render('settings/menu', ['tab' => $tab]);

?>

<h2>Dostępne konta bankowe</h2>
<table class="wp-list-table widefat striped polkurier-admin-table">
    <thead>
    <tr>
        <th>Nazwa</th>
        <th>Numer rachunku</th>
        <th>Domyślne</th>
        <th>Działania</th>
    </tr>
    </thead>
    <?php foreach ($items as $account): ?>
        <tr>
            <td><?php echo $account->alias ?></td>
            <td><?php echo $account->account ?></td>
            <td><?php echo $account->default ? 'Tak' : '' ?></td>
            <td>
                <a href="admin.php?page=polkurier&tab=bank_accounts&action=edit&id=<?php echo $account->id ?>">Edytuj</a>
                &nbsp;
                <a href="admin.php?page=polkurier&tab=bank_accounts&action=delete&id=<?php echo $account->id ?>"
                   onclick="return confirm('Czy na pewno usunąć numer konta?')">Usuń</a>
            </td>
        </tr>
    <?php endforeach ?>
</table>

<form action="admin.php?page=polkurier&tab=bank_accounts&id=<?php echo $bankAccount->id ?>" method="post">
    <table class="form-table">
        <tbody>
        <tr>
            <th scope="row">
                <label for="polkurier_account_name">Nazwa konta bankowego</label>
            </th>
            <td>
                <input required name="polkurier_account_name" id="polkurier_account_name" value="<?php echo $bankAccount->alias ?>">
            </td>
        </tr>
        <tr>
            <th scope="row">
                <label for="polkurier_account_number_cb">Numer konta bankowego</label>
            </th>
            <td>
                <input required pattern="[0-9]{26}" title="Należy podać 26 cyfr" name="polkurier_account" id="polkurier_account" value="<?php echo $bankAccount->account ?>">
            </td>
        </tr>
        <tr>
            <th scope="row">
                <label for="polkurier_default">Domyślne</label>
            </th>
            <td>
                <input type="checkbox" name="polkurier_default" id="polkurier_default" <?php echo $bankAccount->default ? 'checked' : '' ?>>
            </td>
        </tr>
        </tbody>
    </table>
    <?php
    submit_button($bankAccount->id ? "Zapisz" : "Dodaj konto bankowe", "primary", "submit", true, ['onclick' => 'return fn_polkurier_validate(jQuery(\'#polkurier_account\').val())']);
    ?>
</form>

<script type="text/javascript">
    function fn_polkurier_validate(input) {
        input = "PL" + input;
        var iban = String(input).toUpperCase().replace(/[^A-Z0-9]/g, ''),
            code = iban.match(/^([A-Z]{2})(\d{2})([A-Z\d]+)$/),
            digits;
        digits = (code[3] + code[1] + code[2]).replace(/[A-Z]/g, function (letter) {
            return letter.charCodeAt(0) - 55;
        });
        if (mod97(digits) === 1) {
            return true;
        } else {
            alert("Niepoprawny numer rachunku bankowego");
            return false;
        }
    }

    function mod97(string) {
        var checksum = string.slice(0, 2), fragment;
        for (var offset = 2; offset < string.length; offset += 7) {
            fragment = String(checksum) + string.substring(offset, offset + 7);
            checksum = parseInt(fragment, 10) % 97;
        }
        return checksum;
    }
</script>
