<?php

if (!defined('WPINC')) {
    die;
}

use Polkurier\View;
use Polkurier\Models\Courier;

/** @var $tab string */
/** @var $defaultCourier string */
/** @var Courier[] $couriers */

echo View::render('settings/menu', ['tab' => $tab]);

?>

<form method="POST" class="pk-card pk-mt-5 pk-mx-auto pk-w-75 pk-shadow" style="background: white;">
    <div class="pk-card-body">
        <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(320px, 1fr))">
            <?php foreach ($couriers as $courier): ?>
                <div class="pk-my-2">
                    <label>
                        <input
                            type="radio"
                            name="polkurier_default_courier"
                            value="<?php echo $courier->servicecode ?>"
                            <?php echo $courier->servicecode === $defaultCourier ? 'checked' : '' ?>
                        >
                        <strong>
                            <?php echo $courier->name ?>
                        </strong>
                    </label>
                </div>
            <?php endforeach; ?>
        </div>
        <?php submit_button(); ?>
    </div>
</form>
