<?php

if (!defined('WPINC')) {
    die;
}

use Polkurier\MapsToken;
use Polkurier\View;


/** @var MapsToken $mapToken */
/** @var string $tab */

$couriers = [[
    'name' => 'INPOST_PACZKOMAT',
    'title' => 'Paczkomaty InPost',
], [
    'name' => 'POCZTEX_PUNKT',
    'title' => 'Pocztex Punkt',
], [
    'name' => 'DPD',
    'title' => 'Punkt DPD'
], [
    'name' => 'DHL_POINT',
    'title' => 'Punkt DHL'
], [
    'name' => 'UPS_AP_POINT_POINT',
    'title' => 'UPS'
]];

echo View::render('settings/menu', ['tab' => $tab]);


?>
<div class="pk-flex-row">
    <?php foreach ($couriers as $courier): ?>
        <div class="pk-flex-col-6">
            <div class="pk-card pk-mt-5 pk-mx-2 pk-shadow" style="background: white;">
                <div class="pk-card-header">
                    <?php echo $courier['title'] ?>
                </div>
                <div class="pk-card-body">
                    <div id="default-courier-point-label-<?php echo $courier['name'] ?>"
                         class="pk-p-2 pk-m-2 pk-border-1">
                        <?php if (get_option('polkurier_default_point_id_' . $courier['name'])): ?>
                            [<?php echo get_option('polkurier_default_point_id_' . $courier['name']) ?>]
                            <?php echo get_option('polkurier_default_point_label_' . $courier['name']) ?>
                        <?php else: ?>
                            BRAK
                        <?php endif ?>
                    </div>
                    <div style="text-align: center">
                        <button
                            type="button"
                            class="button button-primary"
                            id="default-courier-point-map-<?php echo $courier['name'] ?>"
                        >
                            Wybierz z mapy
                        </button>
                        <button
                            type="button"
                            class="button button-primary"
                            id="delete-default-courier-point-map-<?php echo $courier['name'] ?>"
                        >
                            Wyczyść
                        </button>
                    </div>
                </div>
            </div>
        </div>
    <?php endforeach ?>
</div>
<script>
    var initMapAction = function (options) {

        options.$deleteButton.on('click', function () {
            if (!confirm('Na pewno usunąć wybrany punkt?')) {
                return;
            }
            POLKURIER.showLoadingSpinner(options.$deleteButton);
            jQuery
                .post(POLKURIER.ajaxUrl, {
                    _ajax_nonce: POLKURIER.ajaxNonce,
                    action: '/polkurier/pickup_points/set_default',
                    courier: options.courier,
                })
                .success(function () {
                    options.$label.text('BRAK');
                })
                .always(function () {
                    POLKURIER.hideLoadingSpinner(options.$deleteButton);
                });
        });

        options.$button.on('click', function () {
            var map = new POLKURIER.PointsMap({
                token: '<?php echo $mapToken->getToken() ?>',
                providers: options.providers,
                functions: ['send'],
            });
            map.onConfirm(function (point) {
                var label = point.street + ', ' + point.zip + ' ' + point.city;
                options.$label.text('[' + point.id + '] ' + label);
                POLKURIER.showLoadingSpinner(options.$button);
                jQuery
                    .post(POLKURIER.ajaxUrl, {
                        _ajax_nonce: POLKURIER.ajaxNonce,
                        action: '/polkurier/pickup_points/set_default',
                        courier: options.courier,
                        pointId: point.id,
                        pointLabel: label
                    })
                    .always(function () {
                        POLKURIER.hideLoadingSpinner(options.$button);
                    });
                map.closeMapDialog();
            });
            map.showMapDialog();
        });
    };

    var couriers = {
        INPOST_PACZKOMAT: {
            providers: ['INPOST_PACZKOMAT',]
        },
        POCZTEX_PUNKT: {
            providers: ['POCZTEX_PUNKT'],
        },
        DPD: {
            providers: ['DPD_POINT'],
        },
        DHL_POINT: {
            providers: ['DHL_POINT'],
        },
        UPS_AP_POINT_POINT: {
            providers: ['UPS_AP_POINT_POINT'],
        },
    };

    for (var name in couriers) {
        initMapAction(Object.assign({
            $button: jQuery('#default-courier-point-map-' + name),
            $deleteButton: jQuery('#delete-default-courier-point-map-' + name),
            $label: jQuery('#default-courier-point-label-' + name),
            courier: name,
        }, couriers[name] || {}));
    }
</script>
