<?php

if (!defined('WPINC')) {
    die;
}

/** @var $tab string */
/** @var $config ConfigManager */

use Polkurier\ConfigManager;
use Polkurier\Types\CheckoutPointButtonPosition;
use Polkurier\Types\ConfigType;
use Polkurier\View;


echo View::render('settings/menu', ['tab' => $tab]);


?>
<form method="POST" class="pk-card pk-mt-5 pk-mx-auto pk-w-75 pk-shadow" style="background: white;">
    <div class="pk-card-header">
        Wygląd
    </div>
    <div class="pk-card-body">
        <div class="pk-my-4">
            <label>
                <input type="checkbox"
                       name="polkurier_layout_checkout_full_row" <?php echo get_option('polkurier_layout_checkout_full_row') === '1' ? 'checked' : '' ?>
                       value="1"/>
                <strong>Przycisk "Wybierz paczkomat" / "Wybierz punkt" w jednej komórce</strong>
            </label>
            <div class="pk-ml-5">
                <small>
                    Szablon HTML WooCommerce wykorzystuje tabelki w ostatnim kroku zamówienia,
                    gdzie w lewej komórce zawarty jest tytuł wiersza, a w prawej treść lub opcje do wyboru.
                    Po zaznaczeniu tej opcji komórki zostaną scalone w jedną na całą szerokość wiersza.
                </small>
            </div>
        </div>

        <div class="pk-my-4">
            <label>
                <div>
                    <strong>Pozycja przycisku "Wybierz paczkomat" / "Wybierz punkt"</strong>
                </div>
                <?php
                $LAYOUT_CHECKOUT_POINT_BUTTON_POSITION = (string)get_option('polkurier_layout_checkout_point_button_position');
                ?>
                <select name="polkurier_layout_checkout_point_button_position">
                    <?php foreach (CheckoutPointButtonPosition::NAMES as $id => $name): ?>
                        <option value="<?php echo $id ?>" <?php echo $LAYOUT_CHECKOUT_POINT_BUTTON_POSITION === $id ? 'selected' : '' ?>>
                            <?php echo $name ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </label>
        </div>

        <div class="pk-my-4">
            <label>
                <div>
                    <strong>Sposób pobierania etykiet</strong>
                </div>
                <?php
                    $value = $config->get(ConfigType::PDF_DOWNLOAD_METHOD);
                ?>
                <select name="<?php echo ConfigType::PDF_DOWNLOAD_METHOD ?>">
                    <?php foreach ([
                        'inline' => 'Otwórz w przeglądarce (domyślnie)',
                        'download' => 'Zapisz plik PDF',
                   ] as $id => $name): ?>
                        <option value="<?php echo $id ?>" <?php echo $value === $id ? 'selected' : '' ?>>
                            <?php echo $name ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </label>
        </div>

        <hr>
        <div style="text-align: center" class="pk-mt-4">
            <button type="submit" class="button button-primary"
                    id="delete-default-courier-point-map-INPOST_PACZKOMAT">Zapisz
            </button>
        </div>
    </div>
</form>
