import {html, LitElement} from "../esm/libs/lit.dist.js?ver=2.4.4";
import styles from '../esm/custom-elements/styles.css.js?ver=2.4.4';
import '../esm/custom-elements/pk-badge.js?ver=2.4.4';
import '../esm/custom-elements/pk-card.js?ver=2.4.4';
import '../esm/custom-elements/pk-icon.js?ver=2.4.4';

export class PkAddress extends LitElement {

    static properties = {
        type: {type: String},
        model: {},
    };

    static styles = styles;

    render() {
        return html`
            <div style="display: flex; gap: 1rem">
                <div>
                    <pk-icon icon="${this.type === 'sender' ? 'courier-with-parcel' : 'person'}"></pk-icon>
                </div>
                <div style="flex-grow: 1;">
                    <pk-grid>
                        <pk-col style="--size-lg: 6;">
                            <div>
                                <div class="fw-bold">${this.model?.company || ''}</div>
                                <div class="fw-bold">${this.model?.person || ''}</div>
                                <div>
                                    ${this.model?.street || ''} 
                                    ${this.model?.housenumber || ''}
                                    ${this.model?.flatnumber ? ` / ${this.model?.flatnumber}` : ''}
                                </div>
                                <div>${this.model?.postcode || ''} ${this.model?.city || ''} (${this.model?.country || 'PL'})</div>
                                <div>${this.model?.phone || ''}, ${this.model?.email || ''}</div>
                            </div>
                        </pk-col>
                        <slot name="point">
                            ${this.model?.delivery_point ? html`
                                <pk-col style="--size-lg: 6;">
                                    <div style="display: flex; gap: 0.5rem;" type="Odbiór w punkcie">
                                        <div>
                                            <pk-icon icon="location-pin" size="sm"></pk-icon>
                                        </div>
                                        <div>
                                            <pk-badge type="code" style="font-weight: bold; margin-left: -0.5rem; margin-bottom: 0.5rem">
                                                ${this.model.delivery_point.code}
                                            </pk-badge>
                                            ${this.model.delivery_point.label ? html`
                                                <div class="fs-nano text-muted">${this.model.delivery_point.label}</div>
                                            ` : null}
                                        </div>
                                    </div>
                                </pk-col>
                            ` : null}
                        </slot>
                        <slot></slot>
                    </pk-grid>
                    

                </div>
            </div>
        `
    }
}

customElements.define("pk-address", PkAddress);
