import {html, LitElement} from "../esm/libs/lit.dist.js?ver=2.4.4";
import styles from '../esm/custom-elements/styles.css.js?ver=2.4.4';

export class PkQuickOrderDescriptionEditView extends LitElement {

    static properties = {
        value: {type: String},
    };

    static styles = styles;

    onClickCancelButton() {
        this.dispatchEvent(new CustomEvent('cancel'));
    }

    onClickAcceptButton() {
        this.dispatchEvent(new CustomEvent('confirm'));
    }

    render() {
        return html`
            <div class="d-flex-column gap">
                <div>
                    <label class="pk-label">
                        <strong>Opis zawartości</strong>
                        <input
                            class="pk-input"
                            .value="${this.value || ''}"
                            @change="${e => this.value = e.target.value}"
                        >
                    </label>
                </div>
                <div class="d-flex gap-sm mt" style="justify-content: end;">
                    <button class="btn" @click="${this.onClickCancelButton}">Anuluj</button>
                    <button class="btn btn-primary" @click="${this.onClickAcceptButton}">Zatwierdź</button>
                </div>
            </div>
        `;
    }
}

customElements.define("pk-quick-order-description-edit-view", PkQuickOrderDescriptionEditView);
