import {html, LitElement} from "../esm/libs/lit.dist.js?ver=2.4.4";
import styles from '../esm/custom-elements/styles.css.js?ver=2.4.4';
import {openMapModal} from "../esm/util/map.js?ver=2.4.4";
import {getBaseCourier} from "../esm/util/couriers.js?ver=2.4.4";

export class PkQuickOrderRecipientEditView extends LitElement {

    static properties = {
        address: {type: Object},
    };

    static styles = styles;

    setAddress(props) {
        this.address = {
            ...this.address,
            ...props,
        };
    }

    onClickCancelButton() {
        this.dispatchEvent(new CustomEvent('cancel'));
    }

    onClickAcceptButton() {
        this.dispatchEvent(new CustomEvent('confirm'));
    }

    async onClickSelectPointButton() {
        const courierId = getBaseCourier(this.address?.delivery_point?.provider || '');
        const point = await openMapModal({
            selectedProviders: courierId ? [courierId] : undefined,
            searchQuery: this.address?.point_id || this.address?.postcode || '',
            functions: ['collect'],
        });
        if (point) {
            this.setAddress({
                point_id: point.id,
                delivery_point: {
                    code: point.id,
                    provider: point.provider,
                    label: point.address,
                },
            });
        }
    }

    render() {
        return html`
            <div class="d-flex-column gap">
                <div>
                    <label class="pk-label">
                        <strong>Firma</strong>
                        <input 
                            class="pk-input" 
                            .value="${this.address?.company || ''}"
                            @input="${e => this.setAddress({company: e.target.value})}"
                        >
                    </label>
                </div>
                <div>
                    <label class="pk-label">
                        <strong>Imię i nazwisko</strong>
                        <input 
                            class="pk-input" 
                            .value="${this.address?.person || ''}"
                            @input="${e => this.setAddress({person: e.target.value})}"
                        >
                    </label>
                </div>
                <div class="d-flex gap">
                    <div class="flex-grow-1">
                        <label class="pk-label">
                            <strong>Ulica i numer</strong>
                            <input
                                class="pk-input"
                                .value="${this.address?.street || ''}"
                                @input="${e => this.setAddress({street: e.target.value})}"
                            >
                        </label>
                    </div>
                    <div>
                        <label class="pk-label">
                            <strong>Punkt dostawy / paczkomat</strong>
                            <div class="pk-input cursor-pointer" @click="${this.onClickSelectPointButton}">
                                ${this.address?.point_id || html`
                                    <span class="text-muted">(Brak)</span>
                                `}
                            </div>
                        </label>
                    </div>
                </div>
                <div class="d-flex gap">
                    <div class="flex-grow-1">
                        <label class="pk-label">
                            <strong>Miejscowość</strong>
                            <input
                                class="pk-input"
                                .value="${this.address?.city || ''}"
                                @input="${e => this.setAddress({city: e.target.value})}"
                            >
                        </label>
                    </div>
                    <div>
                        <label class="pk-label">
                            <strong>Kod pocztowy</strong>
                            <input
                                class="pk-input"
                                .value="${this.address?.postcode || ''}"
                                @input="${e => this.setAddress({postcode: e.target.value})}"
                            >
                        </label>
                    </div>
                    <div>
                        <label class="pk-label">
                            <strong>Kraj (kod ISO)</strong>
                            <input
                                class="pk-input"
                                .value="${this.address?.country || ''}"
                                @input="${e => this.setAddress({country: e.target.value})}"
                            >
                        </label>
                    </div>
                </div>
                <div class="d-flex gap-sm">
                    <div class="flex-grow-1">
                        <label class="pk-label">
                            <strong>Numer telefonu</strong>
                            <input
                                class="pk-input"
                                .value="${this.address?.phone || ''}"
                                @input="${e => this.setAddress({phone: e.target.value})}"
                            >
                        </label>
                    </div>
                    <div class="flex-grow-1">
                        <label class="pk-label">
                            <strong>Adres e-mail</strong>
                            <input
                                class="pk-input"
                                .value="${this.address?.email || ''}"
                                @input="${e => this.setAddress({email: e.target.value})}"
                            >
                        </label>
                    </div>
                </div>
                <div class="d-flex gap-sm mt" style="justify-content: end;">
                    <button class="btn" @click="${this.onClickCancelButton}">Anuluj</button>
                    <button class="btn btn-primary" @click="${this.onClickAcceptButton}">Zatwierdź</button>
                </div>
            </div>
        `;
    }
}

customElements.define("pk-quick-order-recipient-edit-view", PkQuickOrderRecipientEditView);
