import {css} from "../libs/lit.dist.js?ver=2.4.4";

export default css`

    :host {
        --width: 16rem;
        --background: rgba(255, 255, 255, 0.9);
        --animation-speed: 0.3s;
        --animation-out-speed: 0.15s;
        word-break: break-word;
    }
    
    dialog::backdrop {
        backdrop-filter: blur(0.2rem);
        background-color: rgba(0, 0, 0, 0);
        transition:
                display var(--animation-speed) ease-out allow-discrete,
                overlay var(--animation-speed) ease-out allow-discrete,
                background-color var(--animation-speed) ease-out,
                backdrop-filter var(--animation-speed) ease-out;
    }

    dialog[open]::backdrop {
        background-color: rgba(0, 0, 0, 0.1);
    }

    @starting-style {
        dialog[open]::backdrop {
            background-color: rgba(0, 0, 0, 0);
        }
    }
    
    dialog {
        width: var(--width);
        padding: 1.25rem;
        border: 0 none;
        border-radius: 1rem;
        background: var(--background);
        box-shadow: 0 0 1.5rem 0 rgba(0, 0, 0, 0.2);
        text-align: center;
        backdrop-filter: blur(1rem);
        -webkit-backdrop-filter: blur(1rem);
        opacity: 0;
        scale: 0;
        transition:
                opacity var(--animation-out-speed) ease-out,
                scale var(--animation-out-speed) ease-out,
                overlay var(--animation-out-speed) ease-out allow-discrete,
                display var(--animation-out-speed) ease-out allow-discrete;
    }

    dialog:focus {
        outline: 0 none;
    }

    dialog[open] {
        opacity: 1;
        scale: 1;
        transition:
            opacity var(--animation-speed) ease-out,
            scale var(--animation-speed) cubic-bezier(.7,1.5,.7,1),
            overlay var(--animation-speed) ease-out allow-discrete,
            display var(--animation-speed) ease-out allow-discrete;
    }
    
    @starting-style {
        dialog[open] {
            opacity: 0;
            scale: 0;
        }
    }
    
    slot[name="title"] {
        display: block;
        font-weight: bold;
        text-align: center;
        font-size: 1.2rem;
        margin-top: 1rem;
        margin-bottom: 1.5rem;
    }
    
    slot[name="footer"] {
        display: flex;
        flex-direction: column;
        margin-top: 2rem;
        gap: 0.75rem;
    }
    
    :host(.no-footer) slot[name="footer"] {
        display: none;
    }
    
    ::slotted(button) {
        display: block;
        width: 100%;
        border: 0 none;
        border-radius: 0.75rem !important;
        background: var(--button-bg-color, #e6e6e6);
        color: var(--button-text-color, #000);
        padding: var(--button-padding, 0.85rem);
        font-weight: bold;
    }
    
    ::slotted(button:hover) {
        background: var(--button-bg-hover-color, #dcdcdc) !important;
    }

    ::slotted(button.primary) {
        --button-bg-color: var(--primary-button-color, var(--pk-alert-dialog-accept-button-color, #3584e4));
        --button-bg-hover-color: var(--primary-button-hover-color, var(--pk-alert-dialog-accept-button-hover-color, #4990e7));
        --button-text-color: var(--primary-button-text-color, var(--pk-alert-dialog-accept-button-text-color, white));
    }

    ::slotted(button.destructive) {
        --button-bg-color: var(--destructive-button-color, var(--pk-alert-dialog-destructive-button-color, #f2d5d5));
        --button-bg-hover-color: var(--destructive-button-hover-color, var(--pk-alert-dialog-destructive-button-hover-color, #efc8c8));
        --button-text-color: var(--destructive-button-text-color, var(--pk-alert-dialog-destructive-button-text-color, #c30000));
    }
    
    slot[name="icon"] {
        color: var(--theme-gray-500, var(--gray-500));
        font-size: 1.8rem;
    }
    
    :host(.large),
    :host([size="large"]) {
        --width: 36rem;
    }    
    
    :host(.large) slot[name="footer"],
    :host([size="large"]) slot[name="footer"] {
        flex-direction: row-reverse;
    }
    
    :host(.horizontal-buttons) slot[name="footer"] {
        flex-direction: row-reverse;
    }

    @media (max-width: 576px) {
        :host dialog {
            --width: calc(100vw - 4rem);
        }
        :host slot[name="footer"] {
            flex-direction: column !important;
        }
    }
    
`;
