import {html, css, LitElement} from "../libs/lit.dist.js?ver=2.4.4";
import styles from './styles.css.js?ver=2.4.4';
import './pk-banner.js?ver=2.4.4';

const ICONS_MAP = {
    success: 'check-circle',
    warning: 'exclamation-triangle',
    danger: 'exclamation-octagon',
    info: 'info-circle',
};

export class PkAlert extends LitElement {

    static styles = [styles, css`
        :host {
            display: block;
        }
        
        ::slotted(p) {
            margin: 0;
        }
    `];

    static properties = {
        type: {type: String},
    }

    get icon() {
        return ICONS_MAP[String(this.type).toLowerCase()] || '';
    }

    render() {
        return html`
            <pk-banner type="${this.type}" icon="${this.icon}">
                <slot></slot>
            </pk-banner>
        `;
    }
}

customElements.define('pk-alert', PkAlert);
