import {html, css, LitElement} from "../libs/lit.dist.js?ver=2.4.4";
import styles from './styles.css.js?ver=2.4.4';
import './pk-card.js?ver=2.4.4';
import './pk-icon.js?ver=2.4.4';

export class PkBanner extends LitElement {

    static updateInfo;

    static styles = [styles, css`
        :host {
            display: block;
        }
    `];

    static properties = {
        type: {type: String},
        icon: {type: String},
    }

    render() {
        return html`
            <pk-card type="${this.type}">
                <div class="d-flex gap align-items-center">
                    <div>
                        <slot name="icon">
                            <pk-icon icon="${this.icon}" size="sm"></pk-icon>
                        </slot>
                    </div>
                    <div>
                        <slot></slot>
                    </div>
                    <div style="margin-left: auto;">
                        <slot name="end"></slot>
                    </div>
                </div>
            </pk-card>
        `;
    }
}

customElements.define('pk-banner', PkBanner);
