
export const getViewportSize = () => {
    return {
        width: Math.max(document.documentElement.clientWidth || 0, window.innerWidth || 0),
        height: Math.max(document.documentElement.clientHeight || 0, window.innerHeight || 0),
    }
};

export function throttle(callback, delay) {
    let timer = null;
    return (...args) => {
        if (timer === null) {
            callback(...args);
            timer = setTimeout(() => {
                timer = null;
            }, delay);
        }
    };
}

export function debounce(callback, timeout){
    let timer;
    return (...args) => {
        clearTimeout(timer);
        timer = setTimeout(() => {
            callback(...args);
        }, timeout);
    };
}
