
/**
 * Formatuje liczbę walutę
 * @param value
 * @returns {string}
 */
export const formatCurrency = value => Number(value).toLocaleString('pl-PL', {
    minimumFractionDigits: 2,
    maximumFractionDigits: 2
});

/**
 * Normalizuje liczbę dziesiętną
 * @param {string|number} value
 * @returns {string}
 */
export const normalizeNumber = value =>  {
    const negative = String(value).substring(0, 1) === '-';
    value = String(value)
        .replace(/,/, '.')
        .replace(/[^\d.]+/g, '')

    const parts = value.split('.');
    if (parts.length <= 1) {
        return (negative ? '-' : '') + value;
    }
    const lastPart = parts.pop();
    return (negative ? '-' : '') + parts.join('') + '.' + lastPart;
};

/**
 * Filtruje wartość wejściową zwracając liczbę
 * @param {string|number} value
 * @returns {number}
 */
export const numberFilter = value =>  Number(normalizeNumber(value));

/**
 * Formatuje numer konta bankowego
 * @param iban
 * @returns {string}
 */
export const formatIban = iban => {
    iban = String(iban).replace(/[^0-9]/g, '');
    if (iban.length === 0) {
        return '';
    }
    return iban.substring(0, 2) + ' ' + iban.substring(2).replace(/(.{4})(?!$)/g, "$1 ");
}
