
if (!window.POLKURIER) {
	window.POLKURIER = {};
}


POLKURIER.indexBy = function (collection, indexer) {
	var index, data = {};
	for (var i = 0; i < collection.length; i++) {
		index = typeof indexer === 'function' ? indexer(collection[i], i, collection) : collection[i][indexer];
		data[index] = collection[i];
	}
	return data;
};

POLKURIER.includesAll = function (arrayA, arrayB) {
	for (var i = 0; i < arrayB.length; i++) {
		if (arrayA.indexOf(arrayB[i]) === -1) {
			return false;
		}
	}
	return true;
};


POLKURIER.includesAny = function (arrayA, arrayB) {
	if (!arrayA || !arrayB) {
		return false;
	}
	for (var i = 0; i < arrayB.length; i++) {
		if (arrayA.indexOf(arrayB[i]) !== -1) {
			return true;
		}
	}
	return false;
};


POLKURIER.includes = function (array, val) {
	return array && array.indexOf(val) !== -1;
};

POLKURIER.createLoadingAnimation = function () {
	return jQuery('<span>').append([
		jQuery('<img>', {
			src: '/wp-admin/images/wpspin_light.gif',
			width: 16,
			height: 16,
		}),
	]);
};

POLKURIER.showLoadingSpinner = function (element) {
	var $el = jQuery(element);
	var $spinner = POLKURIER.createLoadingAnimation();
	$spinner.addClass('pk-loading-spinner');
	$el.prepend($spinner);
	$el.prop('disabled', true);
	return $spinner;
};

POLKURIER.hideLoadingSpinner = function (element) {
	var $el = jQuery(element);
	var $spinner = $el.find('.pk-loading-spinner');
	$spinner.remove();
	$el.prop('disabled', false);
};

POLKURIER.debounce = function debounce (fn, timeout, context) {
	var _t = null;
	return function () {
		if (_t) {
			clearTimeout(_t);
			_t = null;
		}
		var args = arguments;
		_t = setTimeout(function () {
			fn.apply(context, args);
			_t = null;
		}, timeout);
	}
}

POLKURIER.copyToClipboard = function (text) {
	// Działa tylko z HTTPS!
	// @see https://stackoverflow.com/questions/51805395/navigator-clipboard-is-undefined
	// @see https://developer.mozilla.org/en-US/docs/Web/Security/Secure_Contexts
	if (navigator.clipboard) {
		return navigator.clipboard.writeText(String(text));
	}

	// Stary sposób (nie zawsze działa)
	// document.execCommand jest zdeprecjonowany
	// @see https://developer.mozilla.org/en-US/docs/Web/API/Document/execCommand
	console.warn('Copy: Fallback to old API');
	return new Promise((resolve, reject) => {
		const clipboardElement = document.createElement("textarea");
		clipboardElement.style.position = 'fixed';
		clipboardElement.style.top = '0';
		clipboardElement.style.left = '0';
		clipboardElement.style.zIndex = '-1';
		clipboardElement.style.opacity = '0';
		clipboardElement.value = String(text);
		document.body.appendChild(clipboardElement);

		setTimeout(() => {
			try {
				clipboardElement.focus();
				clipboardElement.select();
				document.execCommand('copy');
				document.body.removeChild(clipboardElement);
				resolve();
			} catch (err) {
				reject(err);
			}
		}, 10);
	});
}
