<?php

namespace Polkurier\Blocks;

use Automattic\WooCommerce\StoreApi\Schemas\V1\CartSchema;
use Polkurier\Controller\CheckoutController;
use Polkurier\Http\Request;
use Polkurier\Polkurier;

class WooCommerceBlocksManager
{

    public function initialize(): void
    {
        // Rejestruje integrację z WC Blocks
        add_action('woocommerce_blocks_checkout_block_registration', function ($integration_registry): void {
            $integration_registry->register(new WooCommerceCheckoutIntegration());
        });

        // Rejestruje zapis zmian na froncie
        add_action('woocommerce_blocks_loaded', function (): void {
            woocommerce_store_api_register_update_callback([
                'namespace' => Polkurier::NAME,
                'callback' => function (array $data): void {
                    (new CheckoutController())->handleStoreUpdateCallback(
                        (string)($data['action'] ?? ''),
                        new Request((array)($data['data'] ?? []))
                    );
                }
            ]);

            woocommerce_store_api_register_endpoint_data([
                'endpoint' => CartSchema::IDENTIFIER,
                'namespace' => Polkurier::NAME,
                'data_callback' => static function (): array {
                    return [
                        'polkurier_order_delivery_point' => WC()->session->get(Polkurier::NAME . '_delivery_point') ?: [],
                    ];
                },
                'schema_callback' => static function (): array {
                    return [
                        Polkurier::NAME . '_delivery_point' => [
                            'description' => __('Punkt odbioru', 'polkurier'),
                            'type'        => 'object',
                            'readonly'    => true,
                            'properties'  => [
                                'id' => [
                                    'description' => __('Kod punktu', 'polkurier'),
                                    'type' => 'string',
                                    'readonly' => true,
                                ],
                                'provider' => [
                                    'description' => __('Przewoźnik', 'polkurier'),
                                    'type' => 'string',
                                    'readonly' => true,
                                ],
                                'type' => [
                                    'description' => __('Typ punktu', 'polkurier'),
                                    'type' => 'string',
                                    'readonly' => true,
                                ],
                                'address' => [
                                    'description' => __('Adres punktu', 'polkurier'),
                                    'type' => 'string',
                                    'readonly' => true,
                                ],
                                'cod' => [
                                    'description' => __('Pobranie', 'polkurier'),
                                    'type' => 'string',
                                    'readonly' => true,
                                ],
                                'label' => [
                                    'description' => __('Opis punktu', 'polkurier'),
                                    'type' => 'string',
                                    'readonly' => true,
                                ],
                            ],
                        ],
                    ];
                },
                'schema_type' => ARRAY_A,
            ]);

        });
    }

}
