<?php

namespace Polkurier\Blocks;

use Automattic\WooCommerce\Blocks\Integrations\IntegrationInterface;
use Polkurier\Integrations\FlexibleShipping;
use Polkurier\MapsTokenManager;
use Polkurier\Polkurier;
use Polkurier\ShippingMethods\AbstractShippingMethod;

class WooCommerceCheckoutIntegration implements IntegrationInterface
{

    const SCRIPT_PATH = 'public/js/dist/polkurier-checkout-blocks.js?ver=2.4.4';
    const ASSET_PATH = 'public/js/dist/polkurier-checkout-blocks.asset.php';

    public function get_name()
    {
        return 'polkurier-pl-block';
    }

    /**
     * When called invokes any initialization/setup for the integration.
     */
    public function initialize()
    {
        $script_asset = file_exists(Polkurier::DIR . self::ASSET_PATH)
            ? require(Polkurier::DIR . self::ASSET_PATH)
            : array('dependencies' => array(), 'version' => filemtime(self::SCRIPT_PATH));

        wp_register_script(
            'polkurier-pl-wc-blocks-integration',
            Polkurier::URL . self::SCRIPT_PATH,
            $script_asset['dependencies'],
            $script_asset['version'],
            true
        );
    }

    /**
     * Returns an array of script handles to enqueue in the frontend context.
     *
     * @return string[]
     */
    public function get_script_handles()
    {
        return array('polkurier-pl-wc-blocks-integration');
    }

    /**
     * Returns an array of script handles to enqueue in the editor context.
     *
     * @return string[]
     */
    public function get_editor_script_handles()
    {
        return array('polkurier-pl-wc-blocks-integration');
    }

    /**
     * An array of key, value pairs of data made available to the block on the client side.
     *
     * @return array
     */
    public function get_script_data()
    {
        $polkurier = Polkurier::instance();
        $integrations = $polkurier->getIntegrations();

        $methods = [];
        foreach ($polkurier->getAllShippingMethods() as $shippingMethod) {
            $id = $shippingMethod->id . ':' . $shippingMethod->instance_id;
            if ($shippingMethod instanceof AbstractShippingMethod && $shippingMethod->isParcelPickupPoint()) {
                $methods[] = [
                    'id' => $id,
                    'providers' => [$shippingMethod->getPolkurierId()],
                    'buttonLabel' => $shippingMethod->getSelectButtonLabel(),
                ];
            }
            foreach ($integrations as $integration) {
                if ($integration instanceof FlexibleShipping && $integration->shouldShowMapButton($shippingMethod)) {
                    $methods[] = [
                        'id' => $id,
                        'providers' => $integration->getMapProviders($shippingMethod),
                        'buttonLabel' => $integration->getSelectButtonLabel($shippingMethod),
                    ];
                }
            }
        }

        return [
            'namespace' => $this->get_name(),
            'buttonLabel' => __('Wybierz punkt', 'polkurier'),
            'mapToken' => (string)(new MapsTokenManager())->getToken(),
            'shippingMethods' => $methods,
            'deliveryPoint' => WC()->session
                ? WC()->session->get(Polkurier::NAME . '_delivery_point')
                : null,
        ];
    }

    /**
     * Get the file modified time as a cache buster if we're in dev mode.
     *
     * @param string $file Local path to the file.
     * @return string The cache buster value to use for the given file.
     */
    protected function get_file_version($file)
    {
        return Polkurier::VERSION;
    }

}
