<?php

namespace Polkurier\Controller;

use Exception;
use Polkurier\BankAccounts\BankAccountsManager;
use Polkurier\Http\ErrorJsonResponse;
use Polkurier\Http\JsonResponse;
use Polkurier\Http\Request;
use Polkurier\Normalizer\Normalizer;

class AccountInfoController
{

    private const PROVIDERS = [
        'INPOST_PACZKOMAT',
        'POCZTEX_PUNKT',
        'DPD',
        'DHL_POINT',
        'UPS_AP_POINT_POINT',
    ];

    public function indexAction(Request $request): JsonResponse
    {
        try {
            $defaultPickupPoint = [];
            foreach (self::PROVIDERS as $provider) {
                $defaultPickupPoint[$provider] = [
                    'code' => (string)get_option("polkurier_default_point_id_$provider"),
                    'label' => (string)get_option("polkurier_default_point_label_$provider"),
                ];
            }

            $bankAccounts = (new BankAccountsManager())->getAll();
            $defaultBankAccount = '';
            foreach ($bankAccounts as $bankAccount) {
                if ($bankAccount->default) {
                    $defaultBankAccount = (string)$bankAccount->account;
                }
            }

            if ($defaultBankAccount === '' && count($bankAccounts) > 0) {
                $defaultBankAccount = (string)$bankAccounts[0]->account;
            }

            return new JsonResponse([
                'default_courier' => (string)get_option('polkurier_default_carrier_id'),
                'default_cod_type' => (string)get_option('polkurier_DEFAULT_COD_TYPE', 'S'),
                'default_cod_return_type' => (string)get_option('polkurier_DEFAULT_COD_RETURN_TYPE', 'BA'),
                'default_cod_return_bank_account' => $defaultBankAccount,
                'default_services' => [
                    'SMS_NOTIFICATION_RECIPIENT' => (int)get_option('polkurier_default_courierservice_SMS_NOTIFICATION_RECIPIENT') === 1,
                    'SMS_NOTIFICATION_RECIPIENT_WITH_NAME' => (int)get_option('polkurier_default_courierservice_SMS_NOTIFICATION_RECIPIENT_WITH_NAME') === 1,
                    'COVER_ADDRESS_SENDER' => (int)get_option('polkurier_default_courierservice_COVER_ADDRESS_SENDER') === 1,
                ],
                'default_pickup_point' => $defaultPickupPoint,
                'bank_accounts' => (new Normalizer())->normalize($bankAccounts),
            ]);
        } catch (Exception $e) {
            return ErrorJsonResponse::createFromException($e);
        }
    }

}
