<?php

namespace Polkurier\Controller;


use Polkurier\ApiClient;
use Polkurier\Http\ErrorJsonResponse;
use Polkurier\Http\JsonResponse;
use Polkurier\Http\Request;

class CourierPickupController
{

    public function indexAction(Request $request): JsonResponse
    {
        try {
            return new JsonResponse(
                (new ApiClient())->makeApiRequest('get_courier_pickup_time', [
                    'courier' => $request->request->getString('courier'),
                    'shipfrom' => $request->request->getString('shipfrom'),
                    'shipto' => $request->request->getString('shipto'),
                    'parcel' => $request->request->getString('parcel'),
                ])
            );
        } catch (\Exception $e) {
            return ErrorJsonResponse::createFromException($e);
        }
    }

    public function pickupHoursAction(Request $request): JsonResponse
    {
        try {
            return new JsonResponse(
                (new ApiClient())->makeApiRequest('pickup_courier', [
                    'pickupdate' => $request->request->getString('pickupdate'),
                    'courier' => $request->request->getString('courier'),
                    'shipfrom' => $request->request->getString('shipfrom'),
                    'parcel' => $request->request->getString('parcel'),
                ])
            );
        } catch (\Exception $e) {
            return ErrorJsonResponse::createFromException($e);
        }
    }

}
