<?php

namespace Polkurier\Controller;


use Polkurier\ConfigManager;
use Polkurier\Exception\ApiException;
use Polkurier\Http\FileResponse;
use Polkurier\Http\Request;
use Polkurier\Http\Response;
use Polkurier\Order\OrderDocuments;
use Polkurier\Types\ConfigType;
use Polkurier\View;

class PackagesDocumentsController
{


    private function getFile(string $type): Response
    {
        $request = new Request();
        $config = new ConfigManager();
        try {
            return new FileResponse(
                (new OrderDocuments())->getDocument(
                    $type,
                    $request->query->getArray('label')
                ),
                ($config->getString(ConfigType::PDF_DOWNLOAD_METHOD) ?: 'inline') === 'inline'
            );
        } catch (ApiException $e) {
            return new Response(View::render('error', [
                'message' => $e->getMessage(),
            ]));
        }
    }

    /**
     * @used
     */
    public function labelAction(): Response
    {
        return $this->getFile('label');
    }

    /**
     * @used
     */
    public function protocolAction(): Response
    {
        return $this->getFile('protocol');
    }

}
