<?php

namespace Polkurier\Controller;


use Polkurier\AddressBook\Address;
use Polkurier\AddressBook\AddressBookManager;
use Polkurier\BankAccounts\BankAccount;
use Polkurier\BankAccounts\BankAccountsManager;
use Polkurier\Http\RedirectResponse;
use Polkurier\Http\Request;
use Polkurier\Http\Response;
use Polkurier\PluginInfoProvider;
use Polkurier\Util\Numbers;
use Polkurier\View;

class SettingsBankAccountsController
{

    /**
     * @used
     */
    public function indexAction(): Response
    {
        $request = new Request();
        $manager = new BankAccountsManager();

        if ($request->query->getString('action') === 'delete') {
            $account = $manager->getById($request->query->getString('id'));
            if ($account !== null) {
                $manager->remove($account);
                $manager->save();
            }
        } else if ($request->isPost()) {
            $account = $manager->getById($request->query->getString('id'));
            if ($account === null) {
                $account = new BankAccount();
                $manager->persist($account);
            }

            $account->account = Numbers::ensureDigits($request->request->getString('polkurier_account'));
            $account->alias = $request->request->getString('polkurier_account_name');
            if ($request->request->getBoolean('polkurier_default')) {
                $manager->setDefault($account);
            }
            $manager->save();
        }

        $bankAccount = $manager->getById($request->query->getString('id'));
        if ($bankAccount === null) {
            $bankAccount = new BankAccount();
        }

        return new Response(View::render('settings/bank_accounts', [
            'tab' => $request->query->getString('tab'),
            'items' => $manager->getAll(),
            'bankAccount' => $bankAccount,
        ]));
    }

}
